/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;

public class OrRule
extends AbstractRule {
    private boolean isEnabled = true;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < 3) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(2) == LdapTag.CONTEXT_SPECIFIC_TAG_4.getPrimitiveTag() || this.getDigester().getTag(1) == LdapTag.CONTEXT_SPECIFIC_TAG_9.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        this.getDigester().push(this);
        super.tag(id, isPrimitive, typeClass);
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isEnabled) {
            super.finish();
            BranchNode node = new BranchNode(9);
            while (this.getDigester().peek() instanceof ExprNode) {
                node.addNodeToHead((ExprNode)this.getDigester().pop());
            }
            if (this.getDigester().peek() != this) {
                String msg = "Expected to see an OrRule object on stack but got ";
                msg = msg + this.getDigester().peek().getClass() + " instead";
                throw new IllegalStateException(msg);
            }
            this.getDigester().pop();
            this.getDigester().push(node);
        }
        this.isEnabled = true;
    }
}

