/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.filter.PresenceNode;

public class PresentRule
extends PrimitiveOctetStringRule {
    private boolean isEnabled = true;

    public PresentRule() {
        super(LdapTag.CONTEXT_SPECIFIC_TAG_7);
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < 3) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isEnabled) {
            super.finish();
            ByteBuffer buf = (ByteBuffer)this.getDigester().pop();
            byte[] octets = null;
            if (buf.limit() == buf.capacity() && buf.hasArray()) {
                octets = buf.array();
            } else {
                octets = new byte[buf.remaining()];
                buf.get(octets);
            }
            this.getDigester().push(new PresenceNode(new String(octets)));
        }
        this.isEnabled = true;
    }
}

