/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.filter.SubstringNode;

public class SubstringMatchRule
extends AbstractRule {
    private boolean isEnabled = true;
    private String type = null;
    private String initialStr = null;
    private String finalStr = null;
    private ArrayList any = new ArrayList();

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < 4) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
        if (this.isEnabled) {
            this.type = (String)this.getDigester().pop();
            this.getDigester().push(this);
        }
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isEnabled) {
            super.finish();
            SubstringNode node = new SubstringNode(this.any, this.type, this.initialStr, this.finalStr);
            if (this.getDigester().peek() == this) {
                this.getDigester().pop();
            }
            this.getDigester().push(node);
        }
        this.type = null;
        this.finalStr = null;
        this.isEnabled = true;
        this.initialStr = null;
        this.any = new ArrayList();
    }

    public void setInitial(String initialStr) {
        this.initialStr = initialStr;
    }

    public void setFinalStr(String finalStr) {
        this.finalStr = finalStr;
    }

    public void addAny(String anyStr) {
        this.any.add(anyStr);
    }
}

