/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ExtensibleNode;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.filter.SubstringNode;
import org.apache.ldap.common.message.SearchRequest;

public class SearchRequestEncoder {
    public static final SearchRequestEncoder INSTANCE = new SearchRequestEncoder();

    public TupleNode encode(SearchRequest request) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag(UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getMessageId());
        top.addLast(child);
        child.setParent(top);
        DefaultMutableTupleNode searchReq = new DefaultMutableTupleNode(new Tuple());
        searchReq.getTuple().setTag(LdapTag.SEARCH_REQUEST, false);
        searchReq.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getBase());
        searchReq.addLast(child);
        child.setParent(searchReq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)UniversalTag.ENUMERATED, request.getScope().getLdapValue());
        searchReq.addLast(child);
        child.setParent(searchReq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)UniversalTag.ENUMERATED, request.getDerefAliases().getValue());
        searchReq.addLast(child);
        child.setParent(searchReq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getSizeLimit());
        searchReq.addLast(child);
        child.setParent(searchReq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getTimeLimit());
        searchReq.addLast(child);
        child.setParent(searchReq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getTypesOnly());
        searchReq.addLast(child);
        child.setParent(searchReq);
        this.encode(searchReq, request.getFilter());
        child = this.encode(request.getAttributes());
        searchReq.addLast(child);
        child.setParent(searchReq);
        top.addLast(searchReq);
        searchReq.setParent(top);
        return top;
    }

    public void encode(DefaultMutableTupleNode top, TagEnum tag, SimpleNode node) {
        DefaultMutableTupleNode child = null;
        DefaultMutableTupleNode parent = new DefaultMutableTupleNode(new Tuple());
        parent.getTuple().setTag(tag, false);
        parent.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(node.getAttribute());
        parent.addLast(child);
        child.setParent(parent);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(node.getValue());
        parent.addLast(child);
        child.setParent(parent);
        top.addLast(parent);
        parent.setParent(top);
    }

    public void encode(DefaultMutableTupleNode top, TagEnum tag, SubstringNode node) {
        DefaultMutableTupleNode child = null;
        DefaultMutableTupleNode parent = new DefaultMutableTupleNode(new Tuple());
        parent.getTuple().setTag(tag, false);
        parent.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(node.getAttribute());
        parent.addLast(child);
        child.setParent(parent);
        if (node.getInitial() != null || node.getFinal() != null || node.getAny().size() > 0) {
            DefaultMutableTupleNode seq = new DefaultMutableTupleNode(new Tuple());
            seq.getTuple().setTag(UniversalTag.SEQUENCE_SEQUENCE_OF, false);
            seq.getTuple().setLength(-2);
            if (node.getInitial() != null) {
                child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_0, node.getInitial());
                seq.addLast(child);
                child.setParent(seq);
            }
            if (node.getAny().size() > 0) {
                for (int ii = 0; ii < node.getAny().size(); ++ii) {
                    child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_1, (String)node.getAny().get(ii));
                    seq.addLast(child);
                    child.setParent(seq);
                }
            }
            if (node.getFinal() != null) {
                child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_2, node.getFinal());
                seq.addLast(child);
                child.setParent(seq);
            }
            parent.addLast(seq);
            seq.setParent(parent);
        }
        top.addLast(parent);
        parent.setParent(top);
    }

    public void encode(DefaultMutableTupleNode parent, TagEnum tag, PresenceNode node) {
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_7, node.getAttribute());
        parent.addLast(child);
        child.setParent(parent);
    }

    public void encode(DefaultMutableTupleNode top, TagEnum tag, ExtensibleNode node) {
        DefaultMutableTupleNode child = null;
        DefaultMutableTupleNode parent = new DefaultMutableTupleNode(new Tuple());
        parent.getTuple().setTag(tag, false);
        parent.getTuple().setLength(-2);
        if (node.getMatchingRuleId() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_1, node.getMatchingRuleId());
            parent.addLast(child);
            child.setParent(parent);
        }
        if (node.getAttribute() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_2, node.getAttribute());
            parent.addLast(child);
            child.setParent(parent);
        }
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_3, node.getValue());
        parent.addLast(child);
        child.setParent(parent);
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_4, node.dnAttributes());
        parent.addLast(child);
        child.setParent(parent);
        top.addLast(parent);
        parent.setParent(top);
    }

    public void encodeBranchNode(DefaultMutableTupleNode parent, BranchNode node) {
        DefaultMutableTupleNode child = new DefaultMutableTupleNode(new Tuple());
        if (node.isNegation()) {
            child.getTuple().setTag(LdapTag.CONTEXT_SPECIFIC_TAG_2, false);
            child.getTuple().setLength(-2);
            this.encode(child, node.getChild());
            parent.addLast(child);
            child.setParent(parent);
            return;
        }
        if (node.isConjunction()) {
            child.getTuple().setTag(LdapTag.CONTEXT_SPECIFIC_TAG_0, false);
        } else if (node.isDisjunction()) {
            child.getTuple().setTag(LdapTag.CONTEXT_SPECIFIC_TAG_1, false);
        }
        child.getTuple().setLength(-2);
        ArrayList children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            this.encode(child, (ExprNode)children.get(ii));
        }
        parent.addLast(child);
        child.setParent(parent);
    }

    private void encode(DefaultMutableTupleNode parent, ExprNode filter) {
        if (filter.isLeaf()) {
            LeafNode node = (LeafNode)filter;
            switch (node.getAssertionType()) {
                case 0: {
                    this.encode(parent, (TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_3, (SimpleNode)node);
                    break;
                }
                case 2: {
                    this.encode(parent, (SubstringNode)node);
                    break;
                }
                case 3: {
                    this.encode(parent, (TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_5, (SimpleNode)node);
                    break;
                }
                case 4: {
                    this.encode(parent, (TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_6, (SimpleNode)node);
                    break;
                }
                case 1: {
                    PresenceNode presence = (PresenceNode)node;
                    this.encode(parent, (TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_7, presence);
                }
                case 5: {
                    this.encode(parent, (TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_8, (SimpleNode)node);
                    break;
                }
                case 6: {
                    this.encode(parent, (ExtensibleNode)node);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized assertion type value: " + node.getAssertionType());
                }
            }
            return;
        }
        this.encodeBranchNode(parent, (BranchNode)filter);
    }

    private DefaultMutableTupleNode encode(Collection attributes) {
        DefaultMutableTupleNode child = null;
        DefaultMutableTupleNode parent = new DefaultMutableTupleNode(new Tuple());
        parent.getTuple().setTag(UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        parent.getTuple().setLength(-2);
        Iterator list = attributes.iterator();
        while (list.hasNext()) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((String)list.next());
            parent.addLast(child);
            child.setParent(parent);
        }
        return parent;
    }
}

