/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.exception;

import javax.naming.ServiceUnavailableException;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapServiceUnavailableException
extends ServiceUnavailableException
implements LdapException {
    private final ResultCodeEnum resultCode;

    public LdapServiceUnavailableException(ResultCodeEnum resultCode) {
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapServiceUnavailableException(String explanation, ResultCodeEnum resultCode) {
        super(explanation);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        if (!ResultCodeEnum.getServiceCodes().contains(resultCode)) {
            String msg = "Only the following LDAP result codes can be used: " + ResultCodeEnum.getSearchCodes();
            throw new IllegalArgumentException(msg);
        }
    }

    public final ResultCodeEnum getResultCode() {
        return this.resultCode;
    }
}

