/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.CompareRequest;
import org.apache.ldap.common.message.MessageTypeEnum;

public class CompareRequestImpl
extends AbstractRequest
implements CompareRequest {
    private String name;
    private String attrId;
    private String attrVal;

    public CompareRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.lockCheck("Attempt to alter entry name on locked CompareRequest!");
        this.name = name;
    }

    public String getAssertionValue() {
        return this.attrVal;
    }

    public void setAssertionValue(String attrVal) {
        super.lockCheck("Attempt to alter attribute value of locked CompareRequest");
        this.attrVal = attrVal;
    }

    public String getAttributeId() {
        return this.attrId;
    }

    public void setAttributeId(String attrId) {
        super.lockCheck("Attempt to alter attribute id of locked CompareRequest");
        this.attrId = attrId;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompareRequest req = (CompareRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (this.attrId != null && req.getAttributeId() == null) {
            return false;
        }
        if (this.attrId == null && req.getAttributeId() != null) {
            return false;
        }
        if (this.attrId != null && req.getAttributeId() != null && !this.attrId.equals(req.getAttributeId())) {
            return false;
        }
        if (this.attrVal != null && req.getAssertionValue() == null) {
            return false;
        }
        if (this.attrVal == null && req.getAssertionValue() != null) {
            return false;
        }
        return this.attrVal == null || req.getAssertionValue() == null || this.attrVal.equals(req.getAssertionValue());
    }
}

