/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.name;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.io.IOException;
import java.io.PipedOutputStream;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.ldap.common.exception.LdapInvalidNameException;
import org.apache.ldap.common.exception.LdapNamingException;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.name.NameComponentNormalizer;
import org.apache.ldap.common.name.antlrNameParser;
import org.apache.ldap.common.name.antlrTypeLexer;
import org.apache.ldap.common.name.antlrValueLexer;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.common.util.NestableRuntimeException;
import org.apache.ldap.common.util.ParserPipedInputStream;

public class DnParser
implements NameParser {
    private PipedOutputStream m_parserIn;
    private TokenStreamSelector m_selector;
    private final boolean m_isNormalizing;
    private antlrNameParser m_parser;

    public DnParser() throws NamingException {
        this.m_isNormalizing = false;
        try {
            this.init();
        }
        catch (IOException e) {
            String msg = "failed while initializing a name parser:\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            LdapNamingException ne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
    }

    public DnParser(NameComponentNormalizer a_normalizer) throws NamingException {
        try {
            this.init();
        }
        catch (IOException e) {
            String msg = "failed while initializing a name parser:\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            LdapNamingException ne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        this.m_isNormalizing = true;
        this.m_parser.setNormalizer(a_normalizer);
    }

    public boolean isNormizing() {
        return this.m_isNormalizing;
    }

    private void init() throws IOException {
        this.m_parserIn = new PipedOutputStream();
        this.m_selector = new TokenStreamSelector();
        ParserPipedInputStream in = new ParserPipedInputStream();
        this.m_parserIn.connect(in);
        antlrTypeLexer typeLexer = new antlrTypeLexer(in);
        this.m_selector.addInputStream(typeLexer, "typeLexer");
        antlrValueLexer valueLexer = new antlrValueLexer(typeLexer.getInputState());
        this.m_selector.addInputStream(valueLexer, "valueLexer");
        typeLexer.setSelector(this.m_selector);
        valueLexer.setSelector(this.m_selector);
        this.m_selector.select("typeLexer");
        this.m_parser = new antlrNameParser(this.m_selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name parse(String name, LdapName emptyName) throws NamingException {
        if (name == null || name.trim().equals("")) {
            return null == emptyName ? new LdapName() : emptyName;
        }
        try {
            PipedOutputStream pipedOutputStream = this.m_parserIn;
            synchronized (pipedOutputStream) {
                this.m_parserIn.write(name.getBytes());
                this.m_parserIn.write(35);
                this.m_parserIn.write(10);
                this.m_parserIn.flush();
                if (null == emptyName) {
                    emptyName = new LdapName(this.m_parser.name());
                } else {
                    emptyName.setList(this.m_parser.name());
                }
            }
        }
        catch (IOException e) {
            String msg = "Parser failure on name:\n\t" + name;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
            try {
                this.init();
            }
            catch (IOException initError) {
                throw new LdapNamingException("Failed to reinitialize dn parser", ResultCodeEnum.OTHER);
            }
            throw new LdapNamingException(msg, ResultCodeEnum.OTHER);
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on name:\n\t" + name;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
            try {
                this.init();
            }
            catch (IOException initError) {
                throw new LdapNamingException("Failed to reinitialize dn parser", ResultCodeEnum.OTHER);
            }
            throw new LdapInvalidNameException(msg, ResultCodeEnum.INVALIDDNSYNTAX);
        }
        catch (TokenStreamException e2) {
            String msg = "Parser failure on name:\n\t" + name;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e2);
            try {
                this.init();
            }
            catch (IOException initError) {
                throw new LdapNamingException("Failed to reinitialize dn parser", ResultCodeEnum.OTHER);
            }
            throw new LdapInvalidNameException(msg, ResultCodeEnum.INVALIDDNSYNTAX);
        }
        catch (NestableRuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof NamingException) {
                NamingException ne = (NamingException)throwable;
                throw ne;
            }
            throw e;
        }
        return emptyName;
    }

    public Name parse(String name) throws NamingException {
        return this.parse(name, new LdapName());
    }
}

