/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server;

import java.io.File;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.ldap.common.util.PropertiesUtils;

public class ServerMain {
    private static final int LDAP_PORT = 389;

    public static void main(String[] args) {
        Properties env;
        long startTime = System.currentTimeMillis();
        if (args.length > 0) {
            System.out.println("server: loading properties from " + args[0]);
            env = PropertiesUtils.getProperties(new File(args[0]));
        } else {
            System.out.println("server: using default properties ...");
            env = new Properties();
        }
        if (!env.containsKey("server.net.ldap.port")) {
            int port = 389;
            env.setProperty("server.net.ldap.port", String.valueOf(port));
        }
        env.setProperty("java.naming.provider.url", "ou=system");
        env.setProperty("java.naming.factory.initial", "org.apache.ldap.server.jndi.ServerContextFactory");
        try {
            new InitialDirContext(env);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        System.out.println("server: started in " + (System.currentTimeMillis() - startTime) + " milliseconds");
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep(20000L);
                    try {
                        env.setProperty("server.operation.sync", "true");
                        new InitialDirContext(env);
                        continue block6;
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

