/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.util.DateUtils;
import org.apache.ldap.common.util.NamespaceTools;
import org.apache.ldap.server.AbstractContextPartition;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.SearchEngine;

public final class SystemPartition
extends AbstractContextPartition {
    public static final String ADMIN_PRINCIPAL = "uid=admin,ou=system";
    public static final String ADMIN_UID = "admin";
    public static final byte[] ADMIN_PW = "secret".getBytes();
    public static final String USERS_BASE_DN = "ou=users,ou=system";
    public static final String GROUPS_BASE_DN = "ou=groups,ou=system";
    public static final String SUFFIX = "ou=system";
    private final Name suffix = new LdapName();

    public static final Name getUsersBaseDn() {
        LdapName usersBaseDn = null;
        try {
            usersBaseDn = new LdapName(USERS_BASE_DN);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return usersBaseDn;
    }

    public static final Name getGroupsBaseDn() {
        LdapName groupsBaseDn = null;
        try {
            groupsBaseDn = new LdapName(GROUPS_BASE_DN);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return groupsBaseDn;
    }

    public static final Name getAdminDn() {
        LdapName adminDn = null;
        try {
            adminDn = new LdapName(ADMIN_PRINCIPAL);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return adminDn;
    }

    public SystemPartition(Database db, SearchEngine searchEngine, AttributeType[] indexAttributes) throws NamingException {
        super(db, searchEngine, indexAttributes);
        try {
            this.suffix.add(SUFFIX);
        }
        catch (InvalidNameException invalidNameException) {}
        Attributes attributes = db.getSuffixEntry();
        if (attributes == null) {
            attributes = new LockableAttributesImpl();
            attributes.put("objectClass", "top");
            attributes.put("objectClass", "organizationalUnit");
            attributes.put("creatorsName", ADMIN_PRINCIPAL);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            attributes.put(NamespaceTools.getRdnAttribute(SUFFIX), NamespaceTools.getRdnValue(SUFFIX));
            this.getDb().add(SUFFIX, this.suffix, attributes);
        }
    }

    public final Name getSuffix(boolean normalized) {
        return (Name)this.suffix.clone();
    }

    public final boolean isSuffix(Name dn) {
        return SUFFIX.equals(dn.toString());
    }
}

