/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Evaluator;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.LeafEvaluator;
import org.apache.ldap.server.db.ScopeEvaluator;
import org.apache.ldap.server.db.SubstringEvaluator;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.OidRegistry;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(Database db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        ScopeEvaluator scopeEvaluator = null;
        SubstringEvaluator substringEvaluator = null;
        scopeEvaluator = new ScopeEvaluator(db);
        substringEvaluator = new SubstringEvaluator(db, oidRegistry, attributeTypeRegistry);
        this.leafEvaluator = new LeafEvaluator(db, oidRegistry, attributeTypeRegistry, scopeEvaluator, substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, record);
        }
        BranchNode bnode = (BranchNode)node;
        switch (bnode.getOperator()) {
            case 9: {
                Iterator children = bnode.getChildren().iterator();
                while (children.hasNext()) {
                    ExprNode child = (ExprNode)children.next();
                    if (!this.evaluate(child, record)) continue;
                    return true;
                }
                return false;
            }
            case 10: {
                Iterator children = bnode.getChildren().iterator();
                while (children.hasNext()) {
                    ExprNode child = (ExprNode)children.next();
                    if (this.evaluate(child, record)) continue;
                    return false;
                }
                return true;
            }
            case 11: {
                if (bnode.getChild() != null) {
                    return !this.evaluate(bnode.getChild(), record);
                }
                throw new NamingException("Negation has no child: " + node);
            }
        }
        throw new NamingException("Unrecognized branch node operator: " + bnode.getOperator());
    }
}

