/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.DbSearchResult;
import org.apache.ldap.server.db.IndexRecord;

public class SearchResultEnumeration
implements NamingEnumeration {
    private Database db = null;
    private final String[] attrIds;
    private final NamingEnumeration underlying;

    public SearchResultEnumeration(String[] attrIds, NamingEnumeration underlying, Database db) {
        this.db = db;
        this.attrIds = attrIds;
        this.underlying = underlying;
    }

    public void close() throws NamingException {
        this.underlying.close();
    }

    public boolean hasMore() throws NamingException {
        return this.underlying.hasMore();
    }

    public Object next() throws NamingException {
        Attributes entry;
        IndexRecord rec = (IndexRecord)this.underlying.next();
        String name = this.db.getEntryUpdn(rec.getEntryId());
        if (rec.getAttributes() == null) {
            rec.setAttributes(this.db.lookup(rec.getEntryId()));
        }
        if (this.attrIds == null) {
            entry = (Attributes)rec.getAttributes().clone();
        } else {
            entry = new LockableAttributesImpl();
            int ii = 0;
            while (ii < this.attrIds.length) {
                if (rec.getAttributes().get(this.attrIds[ii]) != null) {
                    Attribute attr = (Attribute)rec.getAttributes().get(this.attrIds[ii]).clone();
                    entry.put(attr);
                }
                ++ii;
            }
        }
        return new DbSearchResult(rec.getEntryId(), name, null, entry);
    }

    public boolean hasMoreElements() {
        return this.underlying.hasMoreElements();
    }

    public Object nextElement() {
        return this.underlying.nextElement();
    }
}

