/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;

public class ASTNode
implements TreeNode {
    private final ASTNode parent;
    private final ExprNode exprNode;
    private final ArrayList children = new ArrayList(2);

    public ASTNode(ASTNode parent, ExprNode exprNode) {
        this.exprNode = exprNode;
        this.parent = parent == null ? this : parent;
        try {
            if (exprNode.isLeaf()) {
                return;
            }
            BranchNode branch = (BranchNode)exprNode;
            ArrayList exprNodes = branch.getChildren();
            int ii = 0;
            while (ii < exprNodes.size()) {
                ExprNode child = (ExprNode)exprNodes.get(ii);
                this.children.add(new ASTNode(this, child));
                ++ii;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return !this.exprNode.isLeaf();
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String toString() {
        return this.exprNode.toString();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }
}

