/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db.jdbm;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.util.LRUMap;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexComparator;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.jdbm.JdbmTable;
import org.apache.ldap.server.schema.SerializableComparator;
import org.apache.regexp.RE;

public class JdbmIndex
implements Index {
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    private AttributeType attribute;
    private JdbmTable forward = null;
    private JdbmTable reverse = null;
    private RecordManager recMan = null;
    private LRUMap keyCache = null;

    public JdbmIndex(AttributeType attribute, RecordManager recMan) throws NamingException {
        this.attribute = attribute;
        this.keyCache = new LRUMap(1000);
        this.recMan = recMan;
        this.initTables();
    }

    public JdbmIndex(AttributeType attribute, String wkDirPath) throws NamingException {
        File file = new File(String.valueOf(wkDirPath) + File.separator + attribute.getName());
        this.attribute = attribute;
        this.keyCache = new LRUMap(1000);
        try {
            String path = file.getAbsolutePath();
            BaseRecordManager base = new BaseRecordManager(path);
            base.disableTransactions();
            this.recMan = new CacheRecordManager(base, new MRU(1000));
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not initialize the record manager");
            ne.setRootCause(e);
            throw ne;
        }
        this.initTables();
    }

    private void initTables() throws NamingException {
        SerializableComparator comp = new SerializableComparator(this.attribute.getEquality().getOid());
        this.forward = new JdbmTable(String.valueOf(this.attribute.getName()) + FORWARD_BTREE, true, this.recMan, new IndexComparator(comp, true));
        this.reverse = new JdbmTable(String.valueOf(this.attribute.getName()) + REVERSE_BTREE, !this.attribute.isSingleValue(), this.recMan, new IndexComparator(comp, false));
    }

    public AttributeType getAttribute() {
        return this.attribute;
    }

    public int count() throws NamingException {
        return this.forward.count();
    }

    public int count(Object attrVal) throws NamingException {
        return this.forward.count(this.getNormalized(attrVal));
    }

    public int count(Object attrVal, boolean isGreaterThan) throws NamingException {
        return this.forward.count(this.getNormalized(attrVal), isGreaterThan);
    }

    public BigInteger forwardLookup(Object attrVal) throws NamingException {
        return (BigInteger)this.forward.get(this.getNormalized(attrVal));
    }

    public Object reverseLookup(BigInteger id) throws NamingException {
        return this.reverse.get(id);
    }

    public synchronized void add(Object attrVal, BigInteger id) throws NamingException {
        this.forward.put(this.getNormalized(attrVal), id);
        this.reverse.put((Object)id, this.getNormalized(attrVal));
    }

    public synchronized void add(Attribute attr, BigInteger id) throws NamingException {
        NamingEnumeration<?> values = attr.getAll();
        this.reverse.put((Object)id, values);
        values = attr.getAll();
        while (values.hasMore()) {
            this.forward.put(values.next(), id);
        }
    }

    public synchronized void add(Attributes attrs, BigInteger id) throws NamingException {
        this.add(attrs.get(this.attribute.getName()), id);
    }

    public synchronized void drop(Object attrVal, BigInteger id) throws NamingException {
        this.forward.remove(this.getNormalized(attrVal), id);
        this.reverse.remove((Object)id, this.getNormalized(attrVal));
    }

    public void drop(BigInteger entryId) throws NamingException {
        NamingEnumeration values = this.reverse.listValues(entryId);
        while (values.hasMore()) {
            this.forward.remove(values.next(), entryId);
        }
        this.reverse.remove(entryId);
    }

    public void drop(Attribute attr, BigInteger id) throws NamingException {
        NamingEnumeration<?> values = attr.getAll();
        if (!values.hasMore()) {
            this.drop(id);
            return;
        }
        this.reverse.remove((Object)id, values);
        values = attr.getAll();
        while (values.hasMore()) {
            this.forward.remove(values.next(), id);
        }
    }

    public void drop(Attributes attrs, BigInteger id) throws NamingException {
        this.drop(attrs.get(this.attribute.getName()), id);
    }

    public IndexEnumeration listReverseIndices(BigInteger id) throws NamingException {
        return new IndexEnumeration(this.reverse.listTuples(id), true);
    }

    public IndexEnumeration listIndices() throws NamingException {
        return new IndexEnumeration(this.forward.listTuples());
    }

    public IndexEnumeration listIndices(Object attrVal) throws NamingException {
        return new IndexEnumeration(this.forward.listTuples(this.getNormalized(attrVal)));
    }

    public IndexEnumeration listIndices(Object attrVal, boolean isGreaterThan) throws NamingException {
        return new IndexEnumeration(this.forward.listTuples(this.getNormalized(attrVal), isGreaterThan));
    }

    public IndexEnumeration listIndices(RE regex) throws NamingException {
        return new IndexEnumeration(this.forward.listTuples(), false, regex);
    }

    public IndexEnumeration listIndices(RE regex, String prefix) throws NamingException {
        return new IndexEnumeration(this.forward.listTuples(this.getNormalized(prefix), true), false, regex);
    }

    public boolean hasValue(Object attrVal, BigInteger id) throws NamingException {
        return this.forward.has(this.getNormalized(attrVal), id);
    }

    public boolean hasValue(Object attrVal, BigInteger id, boolean isGreaterThan) throws NamingException {
        return this.forward.has(this.getNormalized(attrVal), id, isGreaterThan);
    }

    public boolean hasValue(RE regex, BigInteger id) throws NamingException {
        IndexEnumeration list = new IndexEnumeration(this.reverse.listTuples(id), true, regex);
        boolean hasValue = list.hasMore();
        list.close();
        return hasValue;
    }

    public synchronized void close() throws NamingException {
        try {
            this.forward.close();
            this.reverse.close();
            this.recMan.commit();
            this.recMan.close();
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Exception while closing backend index file for attribute " + this.attribute.getName());
            ne.setRootCause(e);
            throw ne;
        }
    }

    public synchronized void sync() throws NamingException {
        try {
            this.recMan.commit();
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Exception while syncing backend index file for attribute " + this.attribute.getName());
            ne.setRootCause(e);
            throw ne;
        }
    }

    public Object getNormalized(Object attrVal) throws NamingException {
        Object normalized = this.keyCache.get(attrVal);
        if (normalized == null) {
            normalized = this.attribute.getEquality().getNormalizer().normalize(attrVal);
            this.keyCache.put(attrVal, normalized);
            this.keyCache.put(normalized, normalized);
        }
        return normalized;
    }
}

