/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db.jdbm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.TupleBrowser;
import org.apache.ldap.common.util.EmptyEnumeration;
import org.apache.ldap.common.util.SingletonEnumeration;
import org.apache.ldap.server.db.DupsEnumeration;
import org.apache.ldap.server.db.KeyOnlyComparator;
import org.apache.ldap.server.db.NoDupsEnumeration;
import org.apache.ldap.server.db.Table;
import org.apache.ldap.server.db.Tuple;
import org.apache.ldap.server.db.TupleComparator;
import org.apache.ldap.server.db.TupleEnumeration;
import org.apache.ldap.server.db.TupleRenderer;
import org.apache.ldap.server.db.jdbm.JdbmTupleBrowser;
import org.apache.ldap.server.schema.SerializableComparator;

public class JdbmTable
implements Table {
    private static final String SZSUFFIX = "_btree_sz";
    private final String name;
    private final RecordManager recMan;
    private final boolean allowsDuplicates;
    private final TupleComparator comparator;
    private int count = 0;
    private BTree bt;
    private TupleRenderer renderer;

    public JdbmTable(String name, boolean allowsDuplicates, RecordManager manager, TupleComparator comparator) throws NamingException {
        long recId;
        this.name = name;
        this.recMan = manager;
        this.comparator = comparator;
        this.allowsDuplicates = allowsDuplicates;
        try {
            recId = this.recMan.getNamedObject(name);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        try {
            if (recId != 0L) {
                this.bt = BTree.load(this.recMan, recId);
                recId = this.recMan.getNamedObject(String.valueOf(name) + SZSUFFIX);
                this.count = (Integer)this.recMan.fetch(recId);
            } else {
                this.bt = BTree.createInstance(this.recMan, comparator.getKeyComparator());
                recId = this.bt.getRecid();
                this.recMan.setNamedObject(name, recId);
                recId = this.recMan.insert(new Integer(0));
                this.recMan.setNamedObject(String.valueOf(name) + SZSUFFIX, recId);
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public JdbmTable(String name, RecordManager manager, SerializableComparator keyComparator) throws NamingException {
        this(name, false, manager, new KeyOnlyComparator(keyComparator));
    }

    public TupleComparator getComparator() {
        return this.comparator;
    }

    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    public String getName() {
        return this.name;
    }

    public TupleRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TupleRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean isSortedDupsEnabled() {
        return this.allowsDuplicates;
    }

    public int count(Object key, boolean isGreaterThan) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public int count(Object key) throws NamingException {
        if (!this.allowsDuplicates) {
            if (this.getRaw(key) == null) {
                return 0;
            }
            return 1;
        }
        TreeSet set = (TreeSet)this.getRaw(key);
        if (set != null) {
            return set.size();
        }
        return 0;
    }

    public int count() throws NamingException {
        return this.count;
    }

    public Object get(Object key) throws NamingException {
        if (this.allowsDuplicates) {
            TreeSet set = (TreeSet)this.getRaw(key);
            if (set == null || set.size() == 0) {
                return null;
            }
            return set.first();
        }
        return this.getRaw(key);
    }

    public boolean has(Object key, Object val, boolean isGreaterThan) throws NamingException {
        TreeSet set = null;
        SortedSet<Object> subset = null;
        if (!this.allowsDuplicates) {
            Object rval = this.getRaw(key);
            if (rval == null) {
                return false;
            }
            if (val.equals(rval)) {
                return true;
            }
            if (this.comparator.compareValue(rval, val) >= 1 && isGreaterThan) {
                return true;
            }
            return this.comparator.compareValue(rval, val) <= 1 && !isGreaterThan;
        }
        set = (TreeSet)this.getRaw(key);
        if (set == null || set.size() == 0) {
            return false;
        }
        subset = isGreaterThan ? set.tailSet(val) : set.headSet(val);
        return subset.size() > 0 || set.contains(val);
    }

    public boolean has(Object key, boolean isGreaterThan) throws NamingException {
        try {
            jdbm.helper.Tuple tuple = this.bt.findGreaterOrEqual(key);
            if (tuple != null && this.comparator.compareKey(tuple.getKey(), key) == 0) {
                return true;
            }
            if (isGreaterThan) {
                return tuple != null;
            }
            TupleBrowser browser = null;
            if (tuple == null) {
                tuple = new jdbm.helper.Tuple();
                browser = this.bt.browse();
                if (browser.getNext(tuple)) {
                    return this.comparator.compareKey(tuple.getKey(), key) <= 0;
                }
            } else {
                browser = this.bt.browse(tuple.getKey());
                if (this.comparator.compareKey(tuple.getKey(), key) <= 0) {
                    return true;
                }
                browser.getNext(tuple);
                while (browser.getPrevious(tuple)) {
                    if (this.comparator.compareKey(tuple.getKey(), key) > 0) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return false;
    }

    public boolean has(Object key, Object value) throws NamingException {
        if (this.allowsDuplicates) {
            TreeSet set = (TreeSet)this.getRaw(key);
            if (set == null) {
                return false;
            }
            return set.contains(value);
        }
        Object obj = this.getRaw(key);
        if (obj == null) {
            return false;
        }
        return obj.equals(value);
    }

    public boolean has(Object key) throws NamingException {
        return this.getRaw(key) != null;
    }

    public Object put(Object key, Object value) throws NamingException {
        Object replaced = null;
        if (this.allowsDuplicates) {
            TreeSet<Object> set = (TreeSet<Object>)this.getRaw(key);
            if (set == null) {
                set = new TreeSet<Object>(this.comparator.getValueComparator());
            } else if (set.contains(value)) {
                return value;
            }
            set.add(value);
            this.putRaw(key, set, true);
            ++this.count;
            return null;
        }
        replaced = this.putRaw(key, value, true);
        if (replaced == null) {
            ++this.count;
        }
        return replaced;
    }

    public Object put(Object key, NamingEnumeration values) throws NamingException {
        TreeSet set = null;
        if (!this.allowsDuplicates) {
            if (values.hasMore()) {
                Object value = values.next();
                if (values.hasMore()) {
                    throw new UnsupportedOperationException("Attempting to put duplicate keys into table " + this.name + " which does not support duplicates");
                }
                return this.put(key, value);
            }
            return null;
        }
        set = (TreeSet)this.getRaw(key);
        if (set == null) {
            set = new TreeSet(this.comparator.getValueComparator());
        }
        while (values.hasMore()) {
            Object val = values.next();
            if (set.contains(val)) continue;
            set.add(val);
            ++this.count;
        }
        return this.putRaw(key, set, true);
    }

    public Object remove(Object key, Object value) throws NamingException {
        if (this.allowsDuplicates) {
            TreeSet set = (TreeSet)this.getRaw(key);
            if (set == null) {
                return null;
            }
            if (set.remove(value)) {
                if (set.isEmpty()) {
                    this.removeRaw(key);
                } else {
                    this.putRaw(key, set, true);
                }
                --this.count;
                return value;
            }
            return null;
        }
        if (this.getRaw(key).equals(value)) {
            return this.removeRaw(key);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object remove(Object key, NamingEnumeration values) throws NamingException {
        set = null;
        if (!this.allowsDuplicates) {
            if (values.hasMore()) {
                value = values.next();
                if (values.hasMore()) {
                    throw new UnsupportedOperationException("Attempting to put duplicate keys into table " + this.name + " which does not support duplicates");
                }
                return this.remove(key, value);
            }
            return null;
        }
        set = (TreeSet)this.getRaw(key);
        if (set != null) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            val = values.next();
            if (set.contains(val)) continue;
            set.remove(val);
            --this.count;
lbl17:
            // 3 sources

            ** while (values.hasMore())
        }
lbl18:
        // 1 sources

        return this.putRaw(key, set, true);
    }

    public Object remove(Object key) throws NamingException {
        Object returned = this.removeRaw(key);
        if (returned == null) {
            return null;
        }
        if (this.allowsDuplicates) {
            TreeSet set = (TreeSet)returned;
            this.count -= set.size();
            return set.first();
        }
        --this.count;
        return returned;
    }

    public NamingEnumeration listValues(Object key) throws NamingException {
        TreeSet set = null;
        if (!this.allowsDuplicates) {
            Object value = this.get(key);
            if (value == null) {
                return new EmptyEnumeration();
            }
            return new SingletonEnumeration(value);
        }
        set = (TreeSet)this.getRaw(key);
        if (set == null) {
            return new EmptyEnumeration();
        }
        final Iterator list = set.iterator();
        return new NamingEnumeration(){

            public void close() {
            }

            public Object nextElement() {
                return list.next();
            }

            public Object next() {
                return list.next();
            }

            public boolean hasMore() {
                return list.hasNext();
            }

            public boolean hasMoreElements() {
                return list.hasNext();
            }
        };
    }

    public NamingEnumeration listTuples() throws NamingException {
        NoDupsEnumeration list = null;
        try {
            JdbmTupleBrowser browser = new JdbmTupleBrowser(this.bt.browse());
            list = new NoDupsEnumeration(browser, true);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        if (this.allowsDuplicates) {
            return new DupsEnumeration(list);
        }
        return list;
    }

    public NamingEnumeration listTuples(Object key) throws NamingException {
        TreeSet set = null;
        if (!this.allowsDuplicates) {
            Object val = this.getRaw(key);
            if (val == null) {
                return new EmptyEnumeration();
            }
            return new SingletonEnumeration(new Tuple(key, this.getRaw(key)));
        }
        set = (TreeSet)this.getRaw(key);
        if (set == null) {
            return new EmptyEnumeration();
        }
        return new TupleEnumeration(key, set.iterator());
    }

    public NamingEnumeration listTuples(Object key, boolean isGreaterThan) throws NamingException {
        NamingEnumeration list = null;
        try {
            if (isGreaterThan) {
                JdbmTupleBrowser browser = new JdbmTupleBrowser(this.bt.browse(key));
                list = new NoDupsEnumeration(browser, isGreaterThan);
            } else {
                Object greaterKey;
                jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
                TupleBrowser browser = this.bt.browse(key);
                if (browser.getNext(tuple) && this.comparator.compareKey(key, greaterKey = tuple.getKey()) != 0) {
                    browser.getPrevious(tuple);
                }
                list = new NoDupsEnumeration(new JdbmTupleBrowser(browser), isGreaterThan);
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Failed to get TupleBrowser on table " + this.name + " using key " + this.renderKey(key));
            ne.setRootCause(e);
            throw ne;
        }
        if (this.allowsDuplicates) {
            list = new DupsEnumeration((NoDupsEnumeration)list);
        }
        return list;
    }

    public NamingEnumeration listTuples(Object key, Object val, boolean isGreaterThan) throws NamingException {
        TreeSet set = null;
        if (!this.allowsDuplicates) {
            Object rval = this.getRaw(key);
            if (rval == null) {
                return new EmptyEnumeration();
            }
            if (val.equals(rval)) {
                return new SingletonEnumeration(new Tuple(key, val));
            }
            if (this.comparator.compareValue(val, rval) >= 1 && isGreaterThan) {
                return new SingletonEnumeration(new Tuple(key, val));
            }
            if (this.comparator.compareValue(val, rval) <= 1 && !isGreaterThan) {
                return new SingletonEnumeration(new Tuple(key, val));
            }
            return new EmptyEnumeration();
        }
        set = (TreeSet)this.getRaw(key);
        if (set == null) {
            return new EmptyEnumeration();
        }
        if (isGreaterThan) {
            return new TupleEnumeration(key, set.tailSet(val).iterator());
        }
        SortedSet<Object> headset = set.headSet(val);
        ArrayList<Object> list = new ArrayList<Object>(set.size() + 1);
        list.addAll(headset);
        if (set.contains(val)) {
            list.add(val);
        }
        Collections.reverse(list);
        return new TupleEnumeration(key, list.iterator());
    }

    public synchronized void close() throws NamingException {
        this.sync();
    }

    public void sync() throws NamingException {
        try {
            long recId = this.recMan.getNamedObject(String.valueOf(this.name) + SZSUFFIX);
            if (0L == recId) {
                recId = this.recMan.insert(new Integer(this.count));
            } else {
                this.recMan.update(recId, new Integer(this.count));
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    private String renderKey(Object obj) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        if (this.renderer == null) {
            buf.append(obj.toString());
        } else {
            buf.append(this.renderer.getKeyString(obj));
        }
        buf.append("'");
        return buf.toString();
    }

    private Object getRaw(Object key) throws NamingException {
        Object val = null;
        if (key == null) {
            return null;
        }
        try {
            val = !this.allowsDuplicates ? this.bt.find(key) : this.bt.find(key);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }

    private Object putRaw(Object key, Object value, boolean doReplace) throws NamingException {
        Object val = null;
        try {
            val = this.bt.insert(key, value, doReplace);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }

    private Object removeRaw(Object key) throws NamingException {
        Object val = null;
        try {
            val = this.bt.remove(key);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }
}

