/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.BindResponseImpl;
import org.apache.ldap.common.message.Control;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;

public class BindHandler
implements MessageHandler {
    private static final Control[] EMPTY = new Control[0];

    public void messageReceived(ProtocolSession session, Object request) {
        LdapContext ctx;
        boolean emptyDn;
        BindRequest req = (BindRequest)request;
        BindResponseImpl resp = new BindResponseImpl(req.getMessageId());
        LdapResultImpl result = new LdapResultImpl(resp);
        resp.setLdapResult(result);
        Hashtable env = SessionRegistry.getSingleton().getEnvironment();
        if (!req.isSimple()) {
            result.setResultCode(ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
            result.setErrorMessage("Only simple binds currently supported");
            session.write(resp);
            return;
        }
        boolean allowAnonymousBinds = true;
        if (env.containsKey("server.disable.anonymous")) {
            allowAnonymousBinds = false;
        }
        boolean emptyCredentials = req.getCredentials() == null || req.getCredentials().length == 0;
        boolean bl = emptyDn = req.getName() == null || req.getName().length() == 0;
        if (emptyCredentials && emptyDn && !allowAnonymousBinds) {
            result.setResultCode(ResultCodeEnum.INSUFFICIENTACCESSRIGHTS);
            String msg = "Bind failure: Anonymous binds have been disabled!";
            result.setErrorMessage(msg);
            session.write(resp);
            return;
        }
        String dn = req.getName();
        byte[] creds = req.getCredentials();
        Hashtable cloned = (Hashtable)env.clone();
        cloned.put("java.naming.security.principal", dn);
        cloned.put("java.naming.security.credentials", creds);
        cloned.put("java.naming.security.authentication", "simple");
        javax.naming.ldap.Control[] connCtls = req.getControls().toArray(EMPTY);
        try {
            if (cloned.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)cloned.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(cloned);
            } else {
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        }
        catch (NamingException e) {
            if (e instanceof LdapException) {
                result.setResultCode(((LdapException)((Object)e)).getResultCode());
            } else {
                result.setResultCode(ResultCodeEnum.getBestEstimate(e, req.getType()));
            }
            String msg = "Bind failure:\n" + ExceptionUtils.getStackTrace(e);
            msg = msg + "\n\nBindRequest = \n" + req.toString();
            result.setErrorMessage(msg);
            session.write(resp);
            return;
        }
        SessionRegistry.getSingleton().setLdapContext(session, ctx);
        result.setResultCode(ResultCodeEnum.SUCCESS);
        result.setMatchedDn(req.getName());
        session.write(resp);
    }
}

