/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.NamingException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ModifyRequest;
import org.apache.ldap.common.message.ModifyResponseImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;

public class ModifyHandler
implements MessageHandler {
    private static final ModificationItem[] EMPTY = new ModificationItem[0];

    public void messageReceived(ProtocolSession session, Object request) {
        ModifyRequest req = (ModifyRequest)request;
        ModifyResponseImpl resp = new ModifyResponseImpl(req.getMessageId());
        resp.setLdapResult(new LdapResultImpl(resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            ModificationItem[] mods = req.getModificationItems().toArray(EMPTY);
            ctx.modifyAttributes(req.getName(), mods);
        }
        catch (NamingException e) {
            String msg = "failed to add entry " + req.getName() + ":\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)((Object)e)).getResultCode() : ResultCodeEnum.getBestEstimate(e, req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write(resp);
            return;
        }
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write(resp);
    }
}

