/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.DITStructureRule;
import org.apache.ldap.common.util.JoinIterator;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.schema.DITStructureRuleRegistry;
import org.apache.ldap.server.schema.DITStructureRuleRegistryMonitor;
import org.apache.ldap.server.schema.DITStructureRuleRegistryMonitorAdapter;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapDitStructureRuleRegistry;

public class GlobalDitStructureRuleRegistry
implements DITStructureRuleRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private DITStructureRuleRegistryMonitor monitor;
    private BootstrapDitStructureRuleRegistry bootstrap;
    private SystemPartition systemPartition;

    public GlobalDitStructureRuleRegistry(SystemPartition systemPartition, BootstrapDitStructureRuleRegistry bootstrap, OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new DITStructureRuleRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
        this.systemPartition = systemPartition;
        if (this.systemPartition == null) {
            throw new NullPointerException("the system partition cannot be null");
        }
    }

    public void setMonitor(DITStructureRuleRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, DITStructureRule dITStructureRule) throws NamingException {
        if (this.byOid.containsKey(dITStructureRule.getOid()) || this.bootstrap.hasDITStructureRule(dITStructureRule.getOid())) {
            NamingException e = new NamingException("dITStructureRule w/ OID " + dITStructureRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITStructureRule, e);
            throw e;
        }
        this.oidRegistry.register(dITStructureRule.getName(), dITStructureRule.getOid());
        this.byOid.put(dITStructureRule.getOid(), dITStructureRule);
        this.oidToSchema.put(dITStructureRule.getOid(), schema);
        this.monitor.registered(dITStructureRule);
    }

    public DITStructureRule lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            DITStructureRule dITStructureRule = (DITStructureRule)this.byOid.get(id);
            this.monitor.lookedUp(dITStructureRule);
            return dITStructureRule;
        }
        if (this.bootstrap.hasDITStructureRule(id)) {
            DITStructureRule dITStructureRule = this.bootstrap.lookup(id);
            this.monitor.lookedUp(dITStructureRule);
            return dITStructureRule;
        }
        NamingException e = new NamingException("dITStructureRule w/ OID " + id + " not registered!");
        this.monitor.lookupFailed(id, e);
        throw e;
    }

    public boolean hasDITStructureRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id)) || this.bootstrap.hasDITStructureRule(id);
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        if (this.bootstrap.hasDITStructureRule(id)) {
            return this.bootstrap.getSchemaName(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return new JoinIterator(new Iterator[]{this.byOid.values().iterator(), this.bootstrap.list()});
    }
}

