/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.SyntaxChecker;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.schema.SyntaxCheckerRegistry;
import org.apache.ldap.server.schema.SyntaxCheckerRegistryMonitor;
import org.apache.ldap.server.schema.SyntaxCheckerRegistryMonitorAdapter;
import org.apache.ldap.server.schema.bootstrap.BootstrapSyntaxCheckerRegistry;

public class GlobalSyntaxCheckerRegistry
implements SyntaxCheckerRegistry {
    private final Map syntaxCheckers;
    private final Map oidToSchema = new HashMap();
    private SyntaxCheckerRegistryMonitor monitor;
    private BootstrapSyntaxCheckerRegistry bootstrap;
    private SystemPartition systemPartition;

    public GlobalSyntaxCheckerRegistry(SystemPartition systemPartition, BootstrapSyntaxCheckerRegistry bootstrap) {
        this.syntaxCheckers = new HashMap();
        this.monitor = new SyntaxCheckerRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
        this.systemPartition = systemPartition;
        if (this.systemPartition == null) {
            throw new NullPointerException("the system partition cannot be null");
        }
    }

    public void setMonitor(SyntaxCheckerRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, String oid, SyntaxChecker syntaxChecker) throws NamingException {
        if (this.syntaxCheckers.containsKey(oid) || this.bootstrap.hasSyntaxChecker(oid)) {
            NamingException e = new NamingException("SyntaxChecker with OID " + oid + " already registered!");
            this.monitor.registerFailed(oid, syntaxChecker, e);
            throw e;
        }
        this.oidToSchema.put(oid, schema);
        this.syntaxCheckers.put(oid, syntaxChecker);
        this.monitor.registered(oid, syntaxChecker);
    }

    public SyntaxChecker lookup(String oid) throws NamingException {
        if (this.syntaxCheckers.containsKey(oid)) {
            SyntaxChecker c = (SyntaxChecker)this.syntaxCheckers.get(oid);
            this.monitor.lookedUp(oid, c);
            return c;
        }
        if (this.bootstrap.hasSyntaxChecker(oid)) {
            SyntaxChecker c = this.bootstrap.lookup(oid);
            this.monitor.lookedUp(oid, c);
            return c;
        }
        NamingException e = new NamingException("SyntaxChecker not found for OID: " + oid);
        this.monitor.lookupFailed(oid, e);
        throw e;
    }

    public boolean hasSyntaxChecker(String oid) {
        return this.syntaxCheckers.containsKey(oid) || this.bootstrap.hasSyntaxChecker(oid);
    }

    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        if (this.oidToSchema.containsKey(oid)) {
            return (String)this.oidToSchema.get(oid);
        }
        if (this.bootstrap.hasSyntaxChecker(oid)) {
            return this.bootstrap.getSchemaName(oid);
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }
}

