/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.server.schema.ObjectClassRegistry;
import org.apache.ldap.server.schema.ObjectClassRegistryMonitor;
import org.apache.ldap.server.schema.ObjectClassRegistryMonitorAdapter;
import org.apache.ldap.server.schema.OidRegistry;

public class BootstrapObjectClassRegistry
implements ObjectClassRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private ObjectClassRegistryMonitor monitor;

    public BootstrapObjectClassRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new ObjectClassRegistryMonitorAdapter();
    }

    public void setMonitor(ObjectClassRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, ObjectClass objectClass) throws NamingException {
        if (this.byOid.containsKey(objectClass.getOid())) {
            NamingException e = new NamingException("objectClass w/ OID " + objectClass.getOid() + " has already been registered!");
            this.monitor.registerFailed(objectClass, e);
            throw e;
        }
        this.oidRegistry.register(objectClass.getName(), objectClass.getOid());
        this.byOid.put(objectClass.getOid(), objectClass);
        this.oidToSchema.put(objectClass.getOid(), schema);
        this.monitor.registered(objectClass);
    }

    public ObjectClass lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("objectClass w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        ObjectClass objectClass = (ObjectClass)this.byOid.get(id);
        this.monitor.lookedUp(objectClass);
        return objectClass;
    }

    public boolean hasObjectClass(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

