/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.MatchingRule;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.common.schema.Syntax;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.ComparatorRegistry;
import org.apache.ldap.server.schema.DITContentRuleRegistry;
import org.apache.ldap.server.schema.DITStructureRuleRegistry;
import org.apache.ldap.server.schema.MatchingRuleRegistry;
import org.apache.ldap.server.schema.MatchingRuleUseRegistry;
import org.apache.ldap.server.schema.NameFormRegistry;
import org.apache.ldap.server.schema.NormalizerRegistry;
import org.apache.ldap.server.schema.ObjectClassRegistry;
import org.apache.ldap.server.schema.ObjectFactoryRegistry;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.ldap.server.schema.Registries;
import org.apache.ldap.server.schema.StateFactoryRegistry;
import org.apache.ldap.server.schema.SyntaxCheckerRegistry;
import org.apache.ldap.server.schema.SyntaxRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapAttributeTypeRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapComparatorRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapDitContentRuleRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapDitStructureRuleRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapMatchingRuleRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapMatchingRuleUseRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapNameFormRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapNormalizerRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapObjectClassRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapObjectFactoryRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapOidRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapStateFactoryRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapSyntaxCheckerRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapSyntaxRegistry;

public class BootstrapRegistries
implements Registries {
    private BootstrapAttributeTypeRegistry attributeTypeRegistry;
    private BootstrapComparatorRegistry comparatorRegistry;
    private BootstrapDitContentRuleRegistry ditContentRuleRegistry;
    private BootstrapDitStructureRuleRegistry ditStructureRuleRegistry;
    private BootstrapMatchingRuleRegistry matchingRuleRegistry;
    private BootstrapMatchingRuleUseRegistry matchingRuleUseRegistry;
    private BootstrapNameFormRegistry nameFormRegistry;
    private BootstrapNormalizerRegistry normalizerRegistry;
    private BootstrapObjectClassRegistry objectClassRegistry;
    private BootstrapOidRegistry oidRegistry = new BootstrapOidRegistry();
    private BootstrapSyntaxCheckerRegistry syntaxCheckerRegistry;
    private BootstrapSyntaxRegistry syntaxRegistry;
    private BootstrapObjectFactoryRegistry objectFactoryRegistry;
    private BootstrapStateFactoryRegistry stateFactoryRegistry;

    public BootstrapRegistries() {
        this.normalizerRegistry = new BootstrapNormalizerRegistry();
        this.comparatorRegistry = new BootstrapComparatorRegistry();
        this.syntaxCheckerRegistry = new BootstrapSyntaxCheckerRegistry();
        this.syntaxRegistry = new BootstrapSyntaxRegistry(this.getOidRegistry());
        this.matchingRuleRegistry = new BootstrapMatchingRuleRegistry(this.getOidRegistry());
        this.attributeTypeRegistry = new BootstrapAttributeTypeRegistry(this.getOidRegistry());
        this.objectClassRegistry = new BootstrapObjectClassRegistry(this.getOidRegistry());
        this.ditContentRuleRegistry = new BootstrapDitContentRuleRegistry(this.getOidRegistry());
        this.ditStructureRuleRegistry = new BootstrapDitStructureRuleRegistry(this.getOidRegistry());
        this.matchingRuleUseRegistry = new BootstrapMatchingRuleUseRegistry();
        this.nameFormRegistry = new BootstrapNameFormRegistry(this.getOidRegistry());
        this.objectFactoryRegistry = new BootstrapObjectFactoryRegistry(this.getOidRegistry());
        this.stateFactoryRegistry = new BootstrapStateFactoryRegistry();
    }

    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return this.attributeTypeRegistry;
    }

    public ComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    public DITContentRuleRegistry getDitContentRuleRegistry() {
        return this.ditContentRuleRegistry;
    }

    public DITStructureRuleRegistry getDitStructureRuleRegistry() {
        return this.ditStructureRuleRegistry;
    }

    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return this.matchingRuleRegistry;
    }

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return this.matchingRuleUseRegistry;
    }

    public NameFormRegistry getNameFormRegistry() {
        return this.nameFormRegistry;
    }

    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    public ObjectClassRegistry getObjectClassRegistry() {
        return this.objectClassRegistry;
    }

    public OidRegistry getOidRegistry() {
        return this.oidRegistry;
    }

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return this.syntaxCheckerRegistry;
    }

    public SyntaxRegistry getSyntaxRegistry() {
        return this.syntaxRegistry;
    }

    public ObjectFactoryRegistry getObjectFactoryRegistry() {
        return this.objectFactoryRegistry;
    }

    public StateFactoryRegistry getStateFactoryRegistry() {
        return this.stateFactoryRegistry;
    }

    public List checkRefInteg() {
        ArrayList errors = new ArrayList();
        Iterator list = this.objectClassRegistry.list();
        while (list.hasNext()) {
            ObjectClass oc = (ObjectClass)list.next();
            this.resolve(oc, errors);
        }
        list = this.attributeTypeRegistry.list();
        while (list.hasNext()) {
            AttributeType at = (AttributeType)list.next();
            this.resolve(at, errors);
        }
        list = this.matchingRuleRegistry.list();
        while (list.hasNext()) {
            MatchingRule mr = (MatchingRule)list.next();
            this.resolve(mr, errors);
        }
        list = this.syntaxRegistry.list();
        while (list.hasNext()) {
            Syntax syntax = (Syntax)list.next();
            this.resolve(syntax, errors);
        }
        return errors;
    }

    private boolean resolve(Syntax syntax, List errors) {
        if (syntax == null) {
            return true;
        }
        try {
            syntax.getSyntaxChecker();
            return true;
        }
        catch (NamingException e) {
            errors.add(e);
            return false;
        }
    }

    private boolean resolve(MatchingRule mr, List errors) {
        String schema;
        boolean isSuccess = true;
        if (mr == null) {
            return true;
        }
        try {
            if (mr.getComparator() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null comparator"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            if (mr.getNormalizer() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null normalizer"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(mr.getSyntax(), errors);
            if (mr.getSyntax() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean resolve(AttributeType at, List errors) {
        boolean isSuccess = true;
        boolean hasMatchingRule = false;
        if (at == null) {
            return true;
        }
        try {
            isSuccess &= this.resolve(at.getSuperior(), errors);
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getEquality(), errors);
            if (at.getEquality() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getOrdering(), errors);
            if (at.getOrdering() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSubstr(), errors);
            if (at.getSubstr() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSyntax(), errors);
            if (at.getSyntax() == null) {
                String schema = this.attributeTypeRegistry.getSchemaName(at.getOid());
                errors.add(new NullPointerException("attributeType " + at.getName() + " in schema " + schema + " with OID " + at.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean resolve(ObjectClass oc, List errors) {
        boolean isSuccess = true;
        if (oc == null) {
            return true;
        }
        ObjectClass[] superiors = new ObjectClass[]{};
        try {
            superiors = oc.getSuperClasses();
        }
        catch (NamingException e) {
            superiors = new ObjectClass[]{};
            isSuccess = false;
            errors.add(e);
        }
        int ii = 0;
        while (ii < superiors.length) {
            isSuccess &= this.resolve(superiors[ii], errors);
            ++ii;
        }
        AttributeType[] mayList = new AttributeType[]{};
        try {
            mayList = oc.getMayList();
        }
        catch (NamingException e) {
            mayList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        int ii2 = 0;
        while (ii2 < mayList.length) {
            isSuccess &= this.resolve(mayList[ii2], errors);
            ++ii2;
        }
        AttributeType[] mustList = new AttributeType[]{};
        try {
            mustList = oc.getMustList();
        }
        catch (NamingException e) {
            mustList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        int ii3 = 0;
        while (ii3 < mustList.length) {
            isSuccess &= this.resolve(mustList[ii3], errors);
            ++ii3;
        }
        return isSuccess;
    }
}

