/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.nio.ByteBuffer;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.MessageParseException;

public abstract class AbstractMessage
implements Message {
    private final int type;
    private int sequence;
    private boolean readHeader;
    private boolean wroteHeader;

    protected AbstractMessage(int type) {
        this.type = type;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public final boolean read(ByteBuffer buf) throws MessageParseException {
        if (!this.readHeader) {
            this.readHeader = this.readHeader(buf);
            if (!this.readHeader) {
                return false;
            }
        }
        if (this.readBody(buf)) {
            this.readHeader = false;
            return true;
        }
        return false;
    }

    private boolean readHeader(ByteBuffer buf) throws MessageParseException {
        if (buf.remaining() < 6) {
            return false;
        }
        short readType = buf.getShort();
        if (this.type != readType) {
            throw new MessageParseException("type mismatches: " + readType + " (expected: " + this.type + ')');
        }
        this.sequence = buf.getInt();
        return true;
    }

    protected abstract boolean readBody(ByteBuffer var1) throws MessageParseException;

    public boolean write(ByteBuffer buf) {
        if (!this.wroteHeader) {
            this.wroteHeader = this.writeHeader(buf);
            if (!this.wroteHeader) {
                return false;
            }
        }
        if (this.writeBody(buf)) {
            this.wroteHeader = false;
            return true;
        }
        return false;
    }

    private boolean writeHeader(ByteBuffer buf) {
        if (buf.remaining() < 6) {
            return false;
        }
        buf.putShort((short)this.type);
        buf.putInt(this.sequence);
        return true;
    }

    protected abstract boolean writeBody(ByteBuffer var1);
}

