/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.fml;

import java.io.Reader;
import java.util.Iterator;
import org.codehaus.doxia.module.fml.model.Faq;
import org.codehaus.doxia.module.fml.model.Faqs;
import org.codehaus.doxia.module.fml.model.Part;
import org.codehaus.doxia.parser.ParseException;
import org.codehaus.doxia.parser.Parser;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class FmlParser
implements Parser {
    public void parse(Reader reader, Sink sink) throws ParseException {
        Faqs faqs;
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            faqs = this.parseFml((XmlPullParser)parser, sink);
        }
        catch (Exception ex) {
            throw new ParseException("Error parsing the model.", ex);
        }
        this.createSink(faqs, sink);
    }

    public Faqs parseFml(XmlPullParser parser, Sink sink) throws Exception {
        Faqs faqs = new Faqs();
        Part currentPart = null;
        Faq currentFaq = null;
        boolean inFaq = false;
        boolean inPart = false;
        boolean inQuestion = false;
        boolean inAnswer = false;
        StringBuffer buffer = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("faqs")) {
                    String title = parser.getAttributeValue(null, "title");
                    if (title != null) {
                        faqs.setTitle(title);
                    }
                } else if (parser.getName().equals("part")) {
                    inPart = true;
                    currentPart = new Part();
                    currentPart.setId(parser.getAttributeValue(null, "id"));
                } else if (parser.getName().equals("title")) {
                    currentPart.setTitle(parser.nextText().trim());
                } else if (parser.getName().equals("faq")) {
                    inFaq = true;
                    currentFaq = new Faq();
                    currentFaq.setId(parser.getAttributeValue(null, "id"));
                }
                if (parser.getName().equals("question")) {
                    buffer = new StringBuffer();
                    inQuestion = true;
                } else if (parser.getName().equals("answer")) {
                    buffer = new StringBuffer();
                    inAnswer = true;
                } else if (inQuestion || inAnswer) {
                    buffer.append("<");
                    buffer.append(parser.getName());
                    int count = parser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        buffer.append(" ");
                        buffer.append(parser.getAttributeName(i));
                        buffer.append("=");
                        buffer.append("\"");
                        buffer.append(parser.getAttributeValue(i));
                        buffer.append("\"");
                    }
                    buffer.append(">");
                }
            } else if (eventType == 3) {
                if (!parser.getName().equals("faqs")) {
                    if (parser.getName().equals("part")) {
                        faqs.addPart(currentPart);
                        currentPart = null;
                        inPart = false;
                    } else if (parser.getName().equals("faq")) {
                        currentPart.addFaq(currentFaq);
                        currentFaq = null;
                        inFaq = false;
                    }
                }
                if (parser.getName().equals("question")) {
                    currentFaq.setQuestion(buffer.toString());
                    inQuestion = false;
                } else if (parser.getName().equals("answer")) {
                    currentFaq.setAnswer(buffer.toString());
                    inAnswer = false;
                } else if (inQuestion || inAnswer) {
                    buffer.append("</");
                    buffer.append(parser.getName());
                    buffer.append(">");
                }
            } else if (eventType == 4 && buffer != null && parser.getText() != null) {
                buffer.append(parser.getText());
            }
            eventType = parser.next();
        }
        return faqs;
    }

    private void createSink(Faqs faqs, Sink sink) {
        Faq faq;
        Iterator faqIterator;
        Part part;
        sink.head();
        sink.title();
        sink.text(faqs.getTitle());
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(faqs.getTitle());
        sink.sectionTitle1_();
        Iterator partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.paragraph();
                sink.bold();
                sink.text(part.getTitle());
                sink.bold_();
                sink.paragraph_();
            }
            sink.numberedList(0);
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.numberedListItem();
                sink.link("#" + faq.getId());
                sink.rawText(faq.getQuestion());
                sink.link_();
                sink.numberedListItem_();
            }
            sink.numberedList_();
        }
        sink.section1_();
        partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            sink.section1();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.sectionTitle1();
                sink.text(part.getTitle());
                sink.sectionTitle1_();
            }
            sink.definitionList();
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.definedTerm();
                sink.anchor(faq.getId());
                sink.rawText(faq.getQuestion());
                sink.anchor_();
                sink.definedTerm_();
                sink.definition();
                sink.paragraph();
                this.writeAnswer(sink, faq.getAnswer());
                sink.paragraph_();
                if (faqIterator.hasNext()) {
                    sink.horizontalRule();
                }
                sink.definition_();
            }
            sink.definitionList_();
            sink.section1_();
        }
        sink.body_();
    }

    private void writeAnswer(Sink sink, String answer) {
        int startSource = answer.indexOf("<source>");
        int endSource = answer.lastIndexOf("</source>");
        if (startSource != -1) {
            sink.rawText(answer.substring(0, startSource));
            sink.verbatim(true);
            sink.text(answer.substring(startSource + "<source>".length(), endSource));
            sink.verbatim_();
            sink.rawText(answer.substring(endSource + "</source>".length()));
        } else {
            sink.rawText(answer);
        }
    }
}

