/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.Rule;
import org.drools.rule.RuleConstructionException;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RuleHandler
extends BaseAbstractHandler
implements Handler {
    static /* synthetic */ Class class$org$drools$rule$RuleSet;
    static /* synthetic */ Class class$org$drools$rule$Rule;
    static /* synthetic */ Class class$org$drools$spi$ImportEntry;
    static /* synthetic */ Class class$org$drools$rule$ApplicationData;
    static /* synthetic */ Class class$org$drools$spi$Functions;

    RuleHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(class$org$drools$rule$RuleSet == null ? (class$org$drools$rule$RuleSet = RuleHandler.class$("org.drools.rule.RuleSet")) : class$org$drools$rule$RuleSet);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(class$org$drools$rule$Rule == null ? (class$org$drools$rule$Rule = RuleHandler.class$("org.drools.rule.Rule")) : class$org$drools$rule$Rule);
            this.validPeers.add(class$org$drools$spi$ImportEntry == null ? (class$org$drools$spi$ImportEntry = RuleHandler.class$("org.drools.spi.ImportEntry")) : class$org$drools$spi$ImportEntry);
            this.validPeers.add(class$org$drools$rule$ApplicationData == null ? (class$org$drools$rule$ApplicationData = RuleHandler.class$("org.drools.rule.ApplicationData")) : class$org$drools$rule$ApplicationData);
            this.validPeers.add(class$org$drools$spi$Functions == null ? (class$org$drools$spi$Functions = RuleHandler.class$("org.drools.spi.Functions")) : class$org$drools$spi$Functions);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        Rule rule;
        SemanticModule module = this.ruleSetReader.lookupSemanticModule(uri, localName);
        RuleFactory factory = module.getRuleFactory(localName);
        this.ruleSetReader.startConfiguration(localName, attrs);
        Configuration config = this.ruleSetReader.endConfiguration();
        try {
            rule = factory.newRule(this.ruleSetReader.getRuleSet(), this.ruleSetReader.getFactoryContext(), config);
            this.startRule(rule, attrs);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing rule", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return rule;
    }

    private void startRule(Rule rule, Attributes attrs) throws SAXException {
        String salienceStr = attrs.getValue("salience");
        String noLoopStr = attrs.getValue("no-loop");
        String ruleDesc = attrs.getValue("description");
        if (salienceStr != null && !salienceStr.trim().equals("")) {
            try {
                int salience = Integer.parseInt(salienceStr.trim());
                rule.setSalience(salience);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("invalid number value for 'salience' attribute: " + salienceStr.trim(), this.ruleSetReader.getLocator());
            }
        }
        if (noLoopStr != null && !noLoopStr.trim().equals("")) {
            try {
                boolean noLoop = new Boolean(noLoopStr.trim());
                rule.setNoLoop(noLoop);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("invalid boolean value for 'no-loop' attribute: " + salienceStr.trim(), this.ruleSetReader.getLocator());
            }
        }
        if (ruleDesc != null && !ruleDesc.trim().equals("")) {
            rule.setDocumentation(ruleDesc);
        }
        rule.setImporter(this.ruleSetReader.getRuleSet().getImporter());
        rule.setApplicationData(this.ruleSetReader.getRuleSet().getApplicationData());
    }

    public Object end(String uri, String localName) throws SAXException {
        try {
            this.ruleSetReader.getRuleSet().addRule((Rule)this.ruleSetReader.getParents().getLast());
        }
        catch (RuleConstructionException e) {
            throw new SAXParseException("error adding rule", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return null;
    }

    public Class generateNodeFor() {
        return class$org$drools$rule$Rule == null ? (class$org$drools$rule$Rule = RuleHandler.class$("org.drools.rule.Rule")) : class$org$drools$rule$Rule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

