/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.builder.util.MetadataBuilderUtils;
import thredds.catalog2.builder.util.ThreddsMetadataBuilderUtils;
import thredds.catalog2.xml.names.DatasetElementNames;
import thredds.catalog2.xml.names.DatasetNodeElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.CatalogRefElementParser;
import thredds.catalog2.xml.parser.stax.DatasetElementParser;
import thredds.catalog2.xml.parser.stax.MetadataElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.ThreddsMetadataElementParser;

class DatasetNodeElementParserHelper {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ThreddsBuilderFactory builderFactory;
    private final PropertyElementParser.Factory propertyElemParserFactory;
    private final DatasetElementParser.Factory datasetElemParserFactory;
    private final CatalogRefElementParser.Factory catRefElemParserFactory;
    private final MetadataElementParser.Factory metadataElemParserFactory;
    private final ThreddsMetadataElementParser.Factory threddsMetadataElemParserFactory;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private String defaultServiceNameInheritedFromAncestors;
    private String defaultServiceNameSpecifiedInSelf;
    private String defaultServiceNameToBeInheritedByDescendants;
    private String idAuthorityInheritedFromAncestors;
    private String idAuthoritySpecifiedInSelf;
    private String idAuthorityToBeInheritedByDescendants;
    private List<MetadataElementParser> metadataForThisDataset;
    private List<MetadataElementParser> metadataInheritedByDescendants;
    private ThreddsMetadataElementParser threddsMetadataElementParser;
    private SplitMetadata finalSplitMetadata;

    DatasetNodeElementParserHelper(DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, DatasetNodeBuilder datasetNodeBuilder, ThreddsBuilderFactory builderFactory) {
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.builderFactory = builderFactory;
        this.propertyElemParserFactory = new PropertyElementParser.Factory();
        this.datasetElemParserFactory = new DatasetElementParser.Factory();
        this.catRefElemParserFactory = new CatalogRefElementParser.Factory();
        this.metadataElemParserFactory = new MetadataElementParser.Factory();
        this.threddsMetadataElemParserFactory = new ThreddsMetadataElementParser.Factory();
        if (parentDatasetNodeElementParserHelper != null) {
            List<MetadataElementParser> metadataInheritedFromAncestors = parentDatasetNodeElementParserHelper.getMetadataInheritedByDescendants();
            if (metadataInheritedFromAncestors != null && !metadataInheritedFromAncestors.isEmpty()) {
                this.metadataInheritedByDescendants = new ArrayList<MetadataElementParser>();
                this.metadataInheritedByDescendants.addAll(metadataInheritedFromAncestors);
                this.metadataForThisDataset = new ArrayList<MetadataElementParser>();
                this.metadataForThisDataset.addAll(metadataInheritedFromAncestors);
            }
            this.defaultServiceNameInheritedFromAncestors = parentDatasetNodeElementParserHelper.getDefaultServiceNameToBeInheritedByDescendants();
            this.idAuthorityInheritedFromAncestors = parentDatasetNodeElementParserHelper.getIdAuthorityToBeInheritedByDescendants();
        }
    }

    String getIdAuthorityInheritedFromAncestors() {
        return this.idAuthorityInheritedFromAncestors;
    }

    void setIdAuthorityInheritedFromAncestors(String idAuthorityInheritedFromAncestors) {
        this.idAuthorityInheritedFromAncestors = idAuthorityInheritedFromAncestors;
    }

    String getIdAuthoritySpecifiedInSelf() {
        return this.idAuthoritySpecifiedInSelf;
    }

    void setIdAuthoritySpecifiedInSelf(String idAuthoritySpecifiedInSelf) {
        this.idAuthoritySpecifiedInSelf = idAuthoritySpecifiedInSelf;
    }

    String getIdAuthorityToBeInheritedByDescendants() {
        return this.idAuthorityToBeInheritedByDescendants;
    }

    void setIdAuthorityToBeInheritedByDescendants(String idAuthorityToBeInheritedByDescendants) {
        this.idAuthorityToBeInheritedByDescendants = idAuthorityToBeInheritedByDescendants;
    }

    String getDefaultServiceNameInheritedFromAncestors() {
        return this.defaultServiceNameInheritedFromAncestors;
    }

    void setDefaultServiceNameInheritedFromAncestors(String defaultServiceNameInheritedFromAncestors) {
        this.defaultServiceNameInheritedFromAncestors = defaultServiceNameInheritedFromAncestors;
    }

    String getDefaultServiceNameSpecifiedInSelf() {
        return this.defaultServiceNameSpecifiedInSelf;
    }

    void setDefaultServiceNameSpecifiedInSelf(String defaultServiceNameSpecifiedInSelf) {
        this.defaultServiceNameSpecifiedInSelf = defaultServiceNameSpecifiedInSelf;
    }

    String getDefaultServiceNameToBeInheritedByDescendants() {
        return this.defaultServiceNameToBeInheritedByDescendants;
    }

    void setDefaultServiceNameToBeInheritedByDescendants(String defaultServiceNameToBeInheritedByDescendants) {
        this.defaultServiceNameToBeInheritedByDescendants = defaultServiceNameToBeInheritedByDescendants;
    }

    public List<MetadataElementParser> getMetadataForThisDataset() {
        if (this.metadataForThisDataset == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.metadataForThisDataset);
    }

    List<MetadataElementParser> getMetadataInheritedByDescendants() {
        if (this.metadataInheritedByDescendants == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.metadataInheritedByDescendants);
    }

    void parseStartElementNameAttribute(StartElement startElement) {
        Attribute att = startElement.getAttributeByName(DatasetElementNames.DatasetElement_Name);
        if (att != null) {
            this.datasetNodeBuilder.setName(att.getValue());
        }
    }

    void parseStartElementIdAttribute(StartElement startElement) {
        Attribute att = startElement.getAttributeByName(DatasetNodeElementNames.DatasetNodeElement_Id);
        if (att != null) {
            this.datasetNodeBuilder.setId(att.getValue());
        }
    }

    void parseStartElementIdAuthorityAttribute(StartElement startElement) {
        Attribute att = startElement.getAttributeByName(DatasetNodeElementNames.DatasetNodeElement_Authority);
        if (att != null) {
            this.setIdAuthoritySpecifiedInSelf(att.getValue());
        }
    }

    boolean handleBasicChildStartElement(StartElement startElement, XMLEventReader reader, DatasetNodeBuilder dsNodeBuilder) throws ThreddsXmlParserException {
        if (this.propertyElemParserFactory.isEventMyStartElement(startElement)) {
            PropertyElementParser parser = this.propertyElemParserFactory.getNewParser(reader, this.builderFactory, dsNodeBuilder);
            parser.parse();
            return true;
        }
        if (this.metadataElemParserFactory.isEventMyStartElement(startElement)) {
            MetadataElementParser parser = this.metadataElemParserFactory.getNewParser(reader, this.builderFactory, dsNodeBuilder, this);
            parser.parse();
            if (this.metadataForThisDataset == null) {
                this.metadataForThisDataset = new ArrayList<MetadataElementParser>();
            }
            this.metadataForThisDataset.add(parser);
            if (parser.doesMetadataElementGetInherited()) {
                if (this.metadataInheritedByDescendants == null) {
                    this.metadataInheritedByDescendants = new ArrayList<MetadataElementParser>();
                }
                this.metadataInheritedByDescendants.add(parser);
            }
            return true;
        }
        if (this.threddsMetadataElemParserFactory.isEventMyStartElement(startElement)) {
            if (this.threddsMetadataElementParser == null) {
                this.threddsMetadataElementParser = this.threddsMetadataElemParserFactory.getNewParser(reader, this.builderFactory, dsNodeBuilder, this, false);
            }
            this.threddsMetadataElementParser.parse();
            return true;
        }
        return false;
    }

    boolean handleCollectionChildStartElement(StartElement startElement, XMLEventReader reader, DatasetNodeBuilder dsNodeBuilder) throws ThreddsXmlParserException {
        if (this.datasetElemParserFactory.isEventMyStartElement(startElement)) {
            DatasetElementParser parser = this.datasetElemParserFactory.getNewParser(reader, this.builderFactory, dsNodeBuilder, this);
            parser.parse();
            return true;
        }
        if (this.catRefElemParserFactory.isEventMyStartElement(startElement)) {
            CatalogRefElementParser parser = this.catRefElemParserFactory.getNewParser(reader, this.builderFactory, dsNodeBuilder, this);
            parser.parse();
            return true;
        }
        return false;
    }

    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        if (this.getDefaultServiceNameToBeInheritedByDescendants() == null) {
            this.setDefaultServiceNameToBeInheritedByDescendants(this.getDefaultServiceNameInheritedFromAncestors());
        }
        if (this.getIdAuthorityToBeInheritedByDescendants() == null) {
            this.setIdAuthorityToBeInheritedByDescendants(this.getIdAuthorityInheritedFromAncestors());
        }
        this.datasetNodeBuilder.setIdAuthority(this.getIdAuthoritySpecifiedInSelf() != null ? this.getIdAuthoritySpecifiedInSelf() : this.getIdAuthorityInheritedFromAncestors());
        if (this.threddsMetadataElementParser != null) {
            this.threddsMetadataElementParser.postProcessingAfterEndElement();
        }
        this.finalSplitMetadata = new SplitMetadata(this.metadataForThisDataset);
    }

    void addFinalThreddsMetadataToDatasetNodeBuilder(DatasetNodeBuilder dsNodeBuilder) {
        ThreddsMetadataBuilder unwrappedThreddsMetadataBuilder = null;
        boolean isUnwrappedEmpty = true;
        if (this.threddsMetadataElementParser != null) {
            unwrappedThreddsMetadataBuilder = this.threddsMetadataElementParser.getSelfBuilder();
            isUnwrappedEmpty = unwrappedThreddsMetadataBuilder.isEmpty();
        }
        if (!isUnwrappedEmpty || !this.finalSplitMetadata.threddsMetadata.isEmpty()) {
            ThreddsMetadataBuilder result = dsNodeBuilder.setNewThreddsMetadataBuilder();
            if (!isUnwrappedEmpty) {
                ThreddsMetadataBuilderUtils.copyThreddsMetadataBuilder(unwrappedThreddsMetadataBuilder, result);
            }
            for (MetadataElementParser mdElemParser : this.finalSplitMetadata.threddsMetadata) {
                ThreddsMetadataBuilderUtils.copyThreddsMetadataBuilder(mdElemParser.getThreddsMetadataBuilder(), result);
            }
        }
    }

    void addFinalMetadataToDatasetNodeBuilder(DatasetNodeBuilder dsNodeBuilder) {
        for (MetadataElementParser currentMetadataElemParser : this.finalSplitMetadata.nonThreddsMetadata) {
            MetadataBuilder newMetadataBuilder = dsNodeBuilder.addMetadata();
            MetadataBuilderUtils.copyMetadataBuilder(currentMetadataElemParser.getSelfBuilder(), newMetadataBuilder);
        }
    }

    private class SplitMetadata {
        final List<MetadataElementParser> threddsMetadata;
        final List<MetadataElementParser> nonThreddsMetadata;

        SplitMetadata(List<MetadataElementParser> metadata) {
            if (metadata == null || metadata.isEmpty()) {
                this.threddsMetadata = Collections.emptyList();
                this.nonThreddsMetadata = Collections.emptyList();
                return;
            }
            this.threddsMetadata = new ArrayList<MetadataElementParser>();
            this.nonThreddsMetadata = new ArrayList<MetadataElementParser>();
            for (MetadataElementParser current : metadata) {
                if (current.isContainsThreddsMetadata()) {
                    this.threddsMetadata.add(current);
                    continue;
                }
                this.nonThreddsMetadata.add(current);
            }
        }
    }
}

