/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class GJNoArguDepthFirstBuilder {
    public static final String visitorName = "GJNoArguDepthFirst";
    public static final String outFilename = "GJNoArguDepthFirst.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;

    public GJNoArguDepthFirstBuilder(Vector classes) {
        this.classList = classes;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateDepthFirstVisitor() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spc = new Spacing(3);
            out.println(Globals.fileHeader(spc));
            out.println();
            out.println(spc.spc + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                out.println(spc.spc + "import " + Globals.nodePackage + ".*;");
            }
            out.println(spc.spc + "import java.util.*;\n");
            out.println(spc.spc + "/**");
            out.println(spc.spc + " * Provides default methods which visit each " + "node in the tree in depth-first");
            out.println(spc.spc + " * order.  Your visitors may extend this class.");
            out.println(spc.spc + " */");
            out.println(spc.spc + "public class " + visitorName + "<R> implements " + "GJNoArguVisitor" + "<R> {");
            this.printAutoVisitorMethods(out);
            spc.updateSpc(1);
            out.println(spc.spc + "//");
            out.println(spc.spc + "// User-generated visitor methods below");
            out.println(spc.spc + "//");
            out.println();
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                out.println(spc.spc + "/**");
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * <PRE>");
                }
                out.println(cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * </PRE>");
                }
                out.println(spc.spc + " */");
                out.print(spc.spc + "public R visit");
                out.println("(" + name + " n) {");
                spc.updateSpc(1);
                out.println(spc.spc + "R _ret=null;");
                Enumeration f = cur.getNameList().elements();
                while (f.hasMoreElements()) {
                    out.println(spc.spc + "n." + (String)f.nextElement() + ".accept(this);");
                }
                out.println(spc.spc + "return _ret;");
                spc.updateSpc(-1);
                out.println(spc.spc + "}\n");
            }
            spc.updateSpc(-1);
            out.println(spc.spc + "}");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Errors.hardErr("Could not generate GJNoArguDepthFirst.java");
        }
    }

    private void printAutoVisitorMethods(PrintWriter out) {
        out.println("   //");
        out.println("   // Auto class visitors--probably don't need to be overridden.");
        out.println("   //");
        out.println(GJNoArguDepthFirstBuilder.getNodeListVisitorStr());
        out.println(GJNoArguDepthFirstBuilder.getNodeListOptionalVisitorStr());
        out.println(GJNoArguDepthFirstBuilder.getNodeOptionalVisitorStr());
        out.println(GJNoArguDepthFirstBuilder.getNodeSequenceVisitorStr());
        out.println(GJNoArguDepthFirstBuilder.getNodeTokenVisitorStr());
    }

    static String getNodeListVisitorStr() {
        StringBuffer buf = new StringBuffer(240);
        buf.append("   public R visit(NodeList n) {\n");
        buf.append("      R _ret=null;\n      int _count=0;\n      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {\n         e.nextElement().accept(this);\n         _count++;\n      }\n      return _ret;\n   }\n");
        return buf.toString();
    }

    static String getNodeListOptionalVisitorStr() {
        StringBuffer buf = new StringBuffer(300);
        buf.append("   public R visit(NodeListOptional n) {\n");
        buf.append("      if ( n.present() ) {\n         R _ret=null;\n         int _count=0;\n         for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {\n            e.nextElement().accept(this);\n            _count++;\n         }\n         return _ret;\n      }\n      else\n         return null;\n   }\n");
        return buf.toString();
    }

    static String getNodeOptionalVisitorStr() {
        StringBuffer buf = new StringBuffer(250);
        buf.append("   public R visit(NodeOptional n) {\n");
        buf.append("      if ( n.present() )\n         return n.node.accept(this);\n      else\n         return null;\n   }\n");
        return buf.toString();
    }

    static String getNodeSequenceVisitorStr() {
        StringBuffer buf = new StringBuffer(250);
        buf.append("   public R visit(NodeSequence n) {\n");
        buf.append("      R _ret=null;\n      int _count=0;\n      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {\n         e.nextElement().accept(this);\n         _count++;\n      }\n      return _ret;\n   }\n");
        return buf.toString();
    }

    static String getNodeTokenVisitorStr() {
        return "   public R visit(NodeToken n) { return null; }\n";
    }
}

