/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Emitter;
import com.github.rjeschke.txtmark.HTML;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LinkRef;
import com.github.rjeschke.txtmark.MarkToken;
import com.github.rjeschke.txtmark.Utils;
import java.util.HashMap;

public class CleaningEmitter
implements Emitter {
    private final HashMap<String, LinkRef> linkRefs = new HashMap();
    private Decorator decorator;

    public CleaningEmitter(Decorator decorator) {
        this.decorator = decorator;
    }

    public CleaningEmitter(Configuration configuration) {
        this.decorator = configuration.decorator;
    }

    @Override
    public void setUseExtensions(boolean useExtensions) {
    }

    @Override
    public void addLinkRef(String key, LinkRef linkRef) {
    }

    @Override
    public void emit(StringBuilder out, Block root) {
        switch (root.type) {
            case RULER: {
                this.decorator.horizontalRuler(out);
                return;
            }
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.decorator.openHeadline(out, root.hlDepth);
                break;
            }
            case PARAGRAPH: {
                this.decorator.openParagraph(out);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                this.decorator.openCodeBlock(out);
                break;
            }
            case BLOCKQUOTE: {
                this.decorator.openBlockquote(out);
                break;
            }
            case UNORDERED_LIST: {
                this.decorator.openUnorderedList(out);
                break;
            }
            case ORDERED_LIST: {
                this.decorator.openOrderedList(out);
                break;
            }
            case LIST_ITEM: {
                this.decorator.openListItem(out);
            }
        }
        if (root.hasLines()) {
            this.emitLines(out, root);
        } else {
            Block block = root.blocks;
            while (block != null) {
                this.emit(out, block);
                block = block.next;
            }
        }
        switch (root.type) {
            case RULER: 
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.decorator.closeHeadline(out, root.hlDepth);
                break;
            }
            case PARAGRAPH: {
                this.decorator.closeParagraph(out);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                this.decorator.closeCodeBlock(out);
                break;
            }
            case BLOCKQUOTE: {
                this.decorator.closeBlockquote(out);
                break;
            }
            case UNORDERED_LIST: {
                this.decorator.closeUnorderedList(out);
                break;
            }
            case ORDERED_LIST: {
                this.decorator.closeOrderedList(out);
                break;
            }
            case LIST_ITEM: {
                this.decorator.closeListItem(out);
            }
        }
    }

    private void emitLines(StringBuilder out, Block block) {
        this.emitMarkedLines(out, block.lines);
    }

    private void emitMarkedLines(StringBuilder out, Line lines) {
        Line line = lines;
        StringBuilder in = new StringBuilder();
        while (line != null) {
            if (!line.isEmpty) {
                in.append(line.value);
            }
            line = line.next;
        }
        this.recursiveEmitLine(out, in.toString(), 0, MarkToken.NONE);
    }

    private int recursiveEmitLine(StringBuilder out, String in, int start, MarkToken token) {
        StringBuilder temp = new StringBuilder();
        block10: for (int pos = start; pos < in.length(); ++pos) {
            MarkToken mt = this.getToken(in, pos);
            if (token != MarkToken.NONE && (mt == token || token == MarkToken.EM_STAR && mt == MarkToken.STRONG_STAR || token == MarkToken.EM_UNDERSCORE && mt == MarkToken.STRONG_UNDERSCORE)) {
                return pos;
            }
            switch (mt) {
                case IMAGE: 
                case LINK: {
                    temp.setLength(0);
                    int b = this.checkLink(temp, in, pos, mt);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case EM_STAR: 
                case EM_UNDERSCORE: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 1, mt);
                    if (b > 0) {
                        this.decorator.openEmphasis(out);
                        out.append((CharSequence)temp);
                        this.decorator.closeEmphasis(out);
                        pos = b;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case STRONG_STAR: 
                case STRONG_UNDERSCORE: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 2, mt);
                    if (b > 0) {
                        this.decorator.openStrong(out);
                        out.append((CharSequence)temp);
                        this.decorator.closeStrong(out);
                        pos = b + 1;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case SUPER: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 1, mt);
                    if (b > 0) {
                        this.decorator.openSuper(out);
                        out.append((CharSequence)temp);
                        this.decorator.closeSuper(out);
                        pos = b;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case CODE_SINGLE: 
                case CODE_DOUBLE: {
                    int a = pos + (mt == MarkToken.CODE_DOUBLE ? 2 : 1);
                    int b = this.findToken(in, a, mt);
                    if (b > 0) {
                        pos = b + (mt == MarkToken.CODE_DOUBLE ? 1 : 0);
                        while (a < b && in.charAt(a) == ' ') {
                            ++a;
                        }
                        if (a >= b) continue block10;
                        while (in.charAt(b - 1) == ' ') {
                            --b;
                        }
                        this.decorator.openCodeSpan(out);
                        Utils.appendCode(out, in, a, b);
                        this.decorator.closeCodeSpan(out);
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case HTML: {
                    temp.setLength(0);
                    int b = this.checkHtml(temp, in, pos);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case ENTITY: {
                    temp.setLength(0);
                    int b = CleaningEmitter.checkEntity(temp, in, pos);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block10;
                    }
                    out.append(in.charAt(pos));
                    continue block10;
                }
                case ESCAPE: {
                    ++pos;
                }
                default: {
                    out.append(in.charAt(pos));
                }
            }
        }
        return -1;
    }

    private MarkToken getToken(String in, int pos) {
        int c0 = pos > 0 ? (int)CleaningEmitter.whitespaceToSpace(in.charAt(pos - 1)) : 32;
        char c = CleaningEmitter.whitespaceToSpace(in.charAt(pos));
        int c1 = pos + 1 < in.length() ? (int)CleaningEmitter.whitespaceToSpace(in.charAt(pos + 1)) : 32;
        int c2 = pos + 2 < in.length() ? (int)CleaningEmitter.whitespaceToSpace(in.charAt(pos + 2)) : 32;
        switch (c) {
            case '*': {
                if (c1 == 42) {
                    return c0 != 32 || c2 != 32 ? MarkToken.STRONG_STAR : MarkToken.EM_STAR;
                }
                return c0 != 32 || c1 != 32 ? MarkToken.EM_STAR : MarkToken.NONE;
            }
            case '_': {
                if (c1 == 95) {
                    return c0 != 32 || c2 != 32 ? MarkToken.STRONG_UNDERSCORE : MarkToken.EM_UNDERSCORE;
                }
                return c0 != 32 || c1 != 32 ? MarkToken.EM_UNDERSCORE : MarkToken.NONE;
            }
            case '!': {
                if (c1 == 91) {
                    return MarkToken.IMAGE;
                }
                return MarkToken.NONE;
            }
            case '[': {
                return MarkToken.LINK;
            }
            case ']': {
                return MarkToken.NONE;
            }
            case '`': {
                return c1 == 96 ? MarkToken.CODE_DOUBLE : MarkToken.CODE_SINGLE;
            }
            case '\\': {
                switch (c1) {
                    case 33: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 60: 
                    case 62: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 123: 
                    case 125: 
                    case 126: {
                        return MarkToken.ESCAPE;
                    }
                }
                return MarkToken.NONE;
            }
            case '<': {
                return MarkToken.HTML;
            }
            case '&': {
                return MarkToken.ENTITY;
            }
        }
        return MarkToken.NONE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int checkLink(StringBuilder out, String in, int start, MarkToken token) {
        boolean isAbbrev = false;
        int pos = start + (token == MarkToken.LINK ? 1 : 2);
        StringBuilder temp = new StringBuilder();
        temp.setLength(0);
        pos = Utils.readMdLinkId(temp, in, pos);
        if (pos < start) {
            return -1;
        }
        String name = temp.toString();
        String link = null;
        String comment = null;
        int oldPos = pos++;
        if ((pos = Utils.skipSpaces(in, pos)) < start) {
            LinkRef lr = this.linkRefs.get(name.toLowerCase());
            if (lr == null) return -1;
            isAbbrev = lr.isAbbrev;
            link = lr.link;
            comment = lr.title;
            pos = oldPos;
        } else if (in.charAt(pos) == '(') {
            ++pos;
            if ((pos = Utils.skipSpaces(in, pos)) < start) {
                return -1;
            }
            temp.setLength(0);
            boolean useLt = in.charAt(pos) == '<';
            int n = pos = useLt ? Utils.readUntil(temp, in, pos + 1, '>') : Utils.readMdLink(temp, in, pos);
            if (pos < start) {
                return -1;
            }
            if (useLt) {
                ++pos;
            }
            link = temp.toString();
            if (in.charAt(pos) == ' ' && (pos = Utils.skipSpaces(in, pos)) > start && in.charAt(pos) == '\"') {
                ++pos;
                temp.setLength(0);
                pos = Utils.readUntil(temp, in, pos, '\"');
                if (pos < start) {
                    return -1;
                }
                comment = temp.toString();
                ++pos;
                if ((pos = Utils.skipSpaces(in, pos)) == -1) {
                    return -1;
                }
            }
            if (in.charAt(pos) != ')') {
                return -1;
            }
        } else if (in.charAt(pos) == '[') {
            ++pos;
            temp.setLength(0);
            pos = Utils.readRawUntil(temp, in, pos, ']');
            if (pos < start) {
                return -1;
            }
            String id = temp.length() > 0 ? temp.toString() : name;
            LinkRef lr = this.linkRefs.get(id.toLowerCase());
            if (lr != null) {
                link = lr.link;
                comment = lr.title;
            }
        } else {
            LinkRef lr = this.linkRefs.get(name.toLowerCase());
            if (lr == null) return -1;
            isAbbrev = lr.isAbbrev;
            link = lr.link;
            comment = lr.title;
            pos = oldPos;
        }
        if (link == null) {
            return -1;
        }
        if (token == MarkToken.LINK) {
            if (isAbbrev && comment != null) {
                return -1;
            }
            this.decorator.openLink(out);
            Utils.appendValue(out, link, 0, link.length());
            if (comment != null) {
                Utils.appendValue(out, comment, 0, comment.length());
            }
            this.recursiveEmitLine(out, name, 0, MarkToken.NONE);
            this.decorator.closeLink(out);
            return pos;
        } else {
            this.decorator.openImage(out);
            Utils.appendValue(out, link, 0, link.length());
            Utils.appendValue(out, name, 0, name.length());
            if (comment != null) {
                Utils.appendValue(out, comment, 0, comment.length());
            }
            this.decorator.closeImage(out);
        }
        return pos;
    }

    private int findToken(String in, int start, MarkToken token) {
        for (int pos = start; pos < in.length(); ++pos) {
            if (this.getToken(in, pos) != token) continue;
            return pos;
        }
        return -1;
    }

    private int checkHtml(StringBuilder out, String in, int start) {
        StringBuilder temp = new StringBuilder();
        temp.setLength(0);
        int pos = Utils.readUntil(temp, in, start + 1, ':', ' ', '>', '\n');
        if (pos != -1 && in.charAt(pos) == ':' && HTML.isLinkPrefix(temp.toString()) && (pos = Utils.readUntil(temp, in, pos, '>')) != -1) {
            String link = temp.toString();
            this.decorator.openLink(out);
            out.append(" href=\"");
            Utils.appendValue(out, link, 0, link.length());
            out.append("\">");
            Utils.appendValue(out, link, 0, link.length());
            this.decorator.closeLink(out);
            return pos;
        }
        temp.setLength(0);
        pos = Utils.readUntil(temp, in, start + 1, '@', ' ', '>', '\n');
        if (pos != -1 && in.charAt(pos) == '@' && (pos = Utils.readUntil(temp, in, pos, '>')) != -1) {
            String link = temp.toString();
            this.decorator.openLink(out);
            out.append(" href=\"");
            Utils.appendMailto(out, "mailto:", 0, 7);
            Utils.appendMailto(out, link, 0, link.length());
            out.append("\">");
            Utils.appendMailto(out, link, 0, link.length());
            this.decorator.closeLink(out);
            return pos;
        }
        if (start + 2 < in.length()) {
            temp.setLength(0);
            return Utils.readXML(out, in, start, true);
        }
        return -1;
    }

    private static int checkEntity(StringBuilder out, String in, int start) {
        int pos = Utils.readUntil(out, in, start, ';');
        if (pos < 0 || out.length() < 3) {
            return -1;
        }
        if (out.charAt(1) == '#') {
            if (out.charAt(2) == 'x' || out.charAt(2) == 'X') {
                if (out.length() < 4) {
                    return -1;
                }
                for (int i = 3; i < out.length(); ++i) {
                    char c = out.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                    return -1;
                }
            } else {
                for (int i = 2; i < out.length(); ++i) {
                    char c = out.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return -1;
                }
            }
        } else {
            for (int i = 1; i < out.length(); ++i) {
                char c = out.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                return -1;
            }
            out.append(';');
            return HTML.isEntity(out.toString()) ? pos : -1;
        }
        out.append(';');
        return pos;
    }

    private static char whitespaceToSpace(char c) {
        return Character.isWhitespace(c) ? (char)' ' : (char)c;
    }
}

