/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.groupValidators;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;

import eu.maydu.gwt.validation.client.GroupValidator;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.transformers.TrimTransformer;
import eu.maydu.gwt.validation.client.validators.StringLengthValidator;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class TrimmedTextLengthValidator extends GroupValidator<TrimmedTextLengthValidator>{

	private TextBoxBase text;
	private SuggestBox suggest;
	
	
	public TrimmedTextLengthValidator(TextBoxBase text, int min, int max, boolean preventsPropagation) {
		super(preventsPropagation);
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		this.text = text;
		setup(min, max);
	}
	
	public TrimmedTextLengthValidator(TextBoxBase text, int min, int max) {
		this(text, min, max, false);
	}
	
	public TrimmedTextLengthValidator(SuggestBox suggest, int min, int max, boolean preventsPropagation) {
		super(preventsPropagation);
		if(suggest == null)
			throw new IllegalArgumentException("suggest must not be null");
		this.suggest = suggest;
		setup(min, max);
	}
	
	public TrimmedTextLengthValidator(SuggestBox suggest, int min, int max) {
		this(suggest, min, max, false);
	}
	
	private void setup(int min, int max) {
		if(text != null) {
			addValidators(
					new TrimTransformer(this.text),
					new StringLengthValidator(this.text, min, max)
					);
		}else {
			addValidators(
					new TrimTransformer(this.suggest),
					new StringLengthValidator(this.suggest, min, max)
					);
		}
	}
	
	
	@Override
	@SuppressWarnings("unchecked")
	public void invokeActions(ValidationResult result) {
		super.invokeActions(result); //Invokes child validators actions
		if(text != null) {
			for(ValidationAction action : getFailureActions()) {
				action.invoke(result, text);
			}
		}else {
			for(ValidationAction action : getFailureActions()) {
				action.invoke(result, suggest);
			}
		}
	}

}
