/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.transformers;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;

import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;


/**
 * This is a gimmick transformer that encrypts a message
 * with the caesar encryption algorithm see: http://en.wikipedia.org/wiki/Caesar_cipher
 * for details. 
 * 
 * 
 * @author Anatol Mayen
 *
 */
public class CaesarEncryptionTransformer extends Validator<CaesarEncryptionTransformer> {

	private TextBox text;
	private int shiftCount;
	
	
	
	public CaesarEncryptionTransformer(TextBox text, int shiftCount) {
		this(false, text, shiftCount);
	}
	
	public CaesarEncryptionTransformer(boolean preventsPropagationOfValidationChain, TextBox text, int shiftCount) {
		super();
		this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
		
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		if(shiftCount < 1 )
			throw new IllegalArgumentException("shift count must be greater than 0");
		this.text = text;
		this.shiftCount = shiftCount;
	}
	
	public ValidationResult validate(ValidationMessages messages) {
		String str = text.getText();
		text.setText(shift(str, shiftCount));
		return null;
	}
	
	
	public void invokeActions(ValidationResult result) {
		//NO-OP because no actions will be invoked by transformer
	}
	
	private String shift(String message, int shiftCount) {
		shiftCount = shiftCount%26;
		
		StringBuffer result = new StringBuffer();
		for(int i=0; i<message.length(); i++) {
			char c = message.charAt(i);
			c += shiftCount;
			result.append(c);
		}
		
		return result.toString();
	}
	
}
