package eu.maydu.gwt.validation.client.validators.strings.algorithms;

import eu.maydu.gwt.validation.client.validators.ValidatorAlgorithmResult;
import eu.maydu.gwt.validation.client.validators.ValidatorAlgorithm;

/**
 * Validates that a given string 'looks like' a valid email
 * address. No further checks are done if the domains are even valid.
 * 
 * @author Anatol Mayen
 *
 */
public class EmailValidatorAlgorithm implements ValidatorAlgorithm<String> {

	/*
	private int maxTldLength = 6;
	private int minDomainLength = 2;
	*/
	
	/**
	 * The only error message provided by this validator.
	 * Parameter 1: The given input
	 */
	public static final int NOT_A_VALID_EMAIL_ADDRESS = 1;
	
	
	/**
	 * Regex taken from: http://www.regular-expressions.info/email.html
	 * by Jan Goyvaerts
	 */
	protected String emailRegex = "[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+[.][A-Za-z]{2,4}";
	
	//"[A-Za-z_0-9]+@[A-Za-z-]{"+minDomainLength+",50}[.][A-Za-z]{1,"+maxTldLength+"}"
	
	public ValidatorAlgorithmResult validate(String input) {
		input = input.trim();
		if(!input.matches(emailRegex))
			return result(input);
		
		return null;
		
		/*
		//We check that we have not a multiple of @'s directly near each other, because that would come through the next check, providing a false positive.
		if(input.contains("@@"))
			return result();
		
		//We should have something like this: aaa@bbb.com 
		String parts[] = input.split("@");
		if(parts.length != 2)
			return result();
		
		//Now we should have something like this parts[0] = aa, parts[1] = bbb.com
		if(!parts[0].matches("[A-Za-z_]"))
			return result(); // invalid character
		String backParts[] = parts[1].split(".");
		if(!parts[1].spli)
		
		*/
	}

	private ValidatorAlgorithmResult result(String input) {
		return new ValidatorAlgorithmResult(NOT_A_VALID_EMAIL_ADDRESS, input);
	}

}
