/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes;

import eu.stamp_project.descartes.DescartesMutater;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationEngine;

public class DescartesMutationEngine
implements MutationEngine {
    private final Predicate<MethodInfo> excludedMethods;
    private final Collection<MutationOperator> operators;

    public DescartesMutationEngine(Collection<MutationOperator> operators) {
        this((MethodInfo m) -> false, operators);
    }

    public DescartesMutationEngine(MutationOperator ... operators) {
        this(Arrays.asList(operators));
    }

    public DescartesMutationEngine(Predicate<MethodInfo> excludedMethods, MutationOperator ... operators) {
        this(excludedMethods, Arrays.asList(operators));
    }

    public DescartesMutationEngine(Predicate<MethodInfo> excludedMethods, Collection<MutationOperator> operators) {
        Objects.requireNonNull(excludedMethods, "Excluded methods predicate can not be null");
        this.excludedMethods = excludedMethods;
        Objects.requireNonNull(operators, "Collection of mutation operators can not be null");
        this.operators = operators;
    }

    public Mutater createMutator(ClassByteArraySource byteSource) {
        return new DescartesMutater(byteSource, this.excludedMethods, this.operators);
    }

    public Collection<String> getMutatorNames() {
        return this.operators.stream().map(MutationOperator::getIdentifier).collect(Collectors.toList());
    }

    public String toString() {
        return "DescartesMutationEngine";
    }

    public String getName() {
        return "descartes";
    }
}

