/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LineCounter {
    private int firstLine;
    private int lastLine;

    public LineCounter() {
        this.reset();
    }

    public void reset() {
        this.firstLine = Integer.MAX_VALUE;
        this.lastLine = Integer.MIN_VALUE;
    }

    public void registerLine(int line) {
        this.firstLine = Math.min(this.firstLine, line);
        this.lastLine = Math.max(this.lastLine, line);
    }

    public boolean empty() {
        return this.firstLine > this.lastLine;
    }

    public int getCount() {
        if (this.empty()) {
            return 0;
        }
        return this.lastLine - this.firstLine + 1;
    }

    public int getFirstLine() {
        this.ensureNotEmpty();
        return this.firstLine;
    }

    public int getLastLine() {
        this.ensureNotEmpty();
        return this.lastLine;
    }

    public Collection<Integer> getShiftedRange() {
        if (this.empty()) {
            return Collections.emptyList();
        }
        return IntStream.rangeClosed(1, this.lastLine - this.firstLine + 1).boxed().collect(Collectors.toList());
    }

    private void ensureNotEmpty() {
        if (this.empty()) {
            throw new NoSuchElementException("Attempt to grab a line from an empty interval");
        }
    }
}

