/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import eu.stamp_project.descartes.codemanipulation.BaseClassVisitor;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.codemanipulation.MethodRewritingVisitor;
import eu.stamp_project.descartes.operators.MutationOperator;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.commons.GeneratorAdapter;

public class MutationClassAdapter
extends BaseClassVisitor {
    private final MutationIdentifier mutation;

    public MutationClassAdapter(MutationIdentifier mutation, ClassVisitor cv) {
        super(cv);
        this.mutation = mutation;
    }

    private boolean shouldNotTarget(MethodInfo method) {
        Location location = this.mutation.getLocation();
        return !location.getMethodDesc().equals(method.getDescriptor()) || !location.getMethodName().equals(method.getName());
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final MethodInfo method = this.createMethodInfo(access, name, desc, signature, exceptions);
        if (this.shouldNotTarget(method)) {
            return methodVisitor;
        }
        final MutationOperator operator = MutationOperator.fromID(this.mutation.getMutator());
        return new MethodRewritingVisitor(methodVisitor){

            @Override
            protected void generateCode() {
                GeneratorAdapter adapter = new GeneratorAdapter(this.mv, method.access, method.name, method.getDescriptor());
                operator.writeMutant(method, adapter);
            }
        };
    }
}

