/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import eu.stamp_project.descartes.codemanipulation.BaseClassVisitor;
import eu.stamp_project.descartes.codemanipulation.BaseMethodVisitor;
import eu.stamp_project.descartes.codemanipulation.LineCounter;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class MutationPointFinder
extends BaseClassVisitor {
    private final Predicate<MethodInfo> excludedMethods;
    private final Collection<MutationOperator> operators;
    private List<MutationDetails> mutationPoints;
    private ClassName className;
    private String source = null;

    public MutationPointFinder(MutationOperator ... operators) {
        this((MethodInfo method) -> false, List.of(operators));
    }

    public MutationPointFinder(Predicate<MethodInfo> excludedMethods, Collection<MutationOperator> operators) {
        Objects.requireNonNull(excludedMethods, "Excluded methods predicate must not be null");
        this.excludedMethods = excludedMethods;
        Objects.requireNonNull(operators, "Collection of mutation operators can not be null");
        if (operators.isEmpty()) {
            throw new IllegalArgumentException("Collection of mutation operators can not be empty");
        }
        this.operators = operators;
    }

    public List<MutationDetails> findMutationPoints(ClassName className, ClassReader reader) {
        Objects.requireNonNull(className, "Class name must not be null for mutation finding");
        this.className = className;
        this.mutationPoints = new ArrayList<MutationDetails>();
        reader.accept((ClassVisitor)this, 0);
        return this.mutationPoints;
    }

    public void visitSource(String source, String debug) {
        this.source = source;
    }

    private boolean canNotMutate(MethodInfo method) {
        return method.hasNoCode() || method.isConstructor() || this.excludedMethods.test(method);
    }

    private Set<MutationOperator> getOperatorsFor(MethodInfo method) {
        return this.operators.stream().filter(op -> op.canMutate(method)).collect(Collectors.toSet());
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodInfo method = this.createMethodInfo(access, name, desc, signature, exceptions);
        if (this.canNotMutate(method)) {
            return null;
        }
        final Set<MutationOperator> selectedOperators = this.getOperatorsFor(method);
        if (selectedOperators.isEmpty()) {
            return null;
        }
        return new BaseMethodVisitor(){
            LineCounter counter = new LineCounter();
            MutationContext ctx;

            public void visitLineNumber(int line, Label start) {
                this.counter.registerLine(line);
            }

            public void visitEnd() {
                if (!this.counter.empty()) {
                    MutationPointFinder.this.registerMutations(method, selectedOperators, this.counter);
                }
            }
        };
    }

    private void registerMutations(MethodInfo method, Set<MutationOperator> operators, LineCounter lines) {
        Location location = new Location(this.className, method.getName(), method.getDescriptor());
        Collection<Integer> indexes = lines.getShiftedRange();
        this.mutationPoints.addAll(operators.stream().map(op -> new MutationDetails(new MutationIdentifier(location, indexes, op.getIdentifier()), this.source, op.getDescription(), lines.getFirstLine(), 0)).collect(Collectors.toSet()));
    }
}

