/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import eu.stamp_project.descartes.codemanipulation.ElementInfo;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.reloc.asm.Type;

public class TypeInfo
extends ElementInfo {
    public static final int UNKNOWN_VERSION = -1;
    private final int version;
    private final Type type;
    private final Type superType;
    private final Set<Type> interfaces;

    public TypeInfo(Class<?> type) {
        super(type.getModifiers(), Type.getType(type).getInternalName(), type.toGenericString());
        this.version = -1;
        this.type = Type.getType(type);
        this.superType = Type.getType(type.getSuperclass());
        this.interfaces = Stream.of(type.getInterfaces()).map(Type::getType).collect(Collectors.toSet());
    }

    public TypeInfo(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super(access, name, signature);
        this.version = version;
        this.type = Type.getObjectType((String)name);
        this.superType = Type.getObjectType((String)superName);
        this.interfaces = this.toTypeSet(interfaces);
    }

    public int getVersion() {
        return this.version;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public Set<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean canBeAssignedTo(Type other) {
        return this.type.equals((Object)other) || this.superType.equals((Object)other) || this.interfaces.contains(other) || other.equals((Object)Type.getType(Object.class));
    }
}

