/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.interceptors;

import eu.stamp_project.descartes.interceptors.SkipShortMethodsFilter;
import java.util.Optional;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;

public class SkipShortMethodsFilterFactory
implements MutationInterceptorFactory {
    protected static final int DEFAULT_THRESHOLD = 5;
    private static final String DESCRIPTION = "Skips any method shorter than a given number of lines. Default threshold is 5";
    private static final FeatureParameter LINES = FeatureParameter.named((String)"lines").withDescription("Threshold for the size of the methods in lines.");

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        Optional lines = interceptorParameters.getInteger(LINES);
        return new SkipShortMethodsFilter(lines.orElse(5));
    }

    public Feature provides() {
        return Feature.named((String)"SKIP_SHORT").withDescription(DESCRIPTION).withOnByDefault(false).withParameter(LINES);
    }

    public String description() {
        return DESCRIPTION;
    }
}

