/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.interceptors.stopmethods;

import eu.stamp_project.descartes.interceptors.stopmethods.StopMethodMatcher;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceQuery;

public class StopMethodMatchers {
    private StopMethodMatchers() {
    }

    static StopMethodMatcher isEnumGenerated() {
        return (classTree, methodTree) -> {
            ClassNode classNode = classTree.rawNode();
            if (!classNode.superName.equals("java/lang/Enum")) {
                return false;
            }
            MethodNode methodNode = methodTree.rawNode();
            if ((methodNode.access & 8) == 0) {
                return false;
            }
            String returnTypeDescription = "L" + classNode.name + ";";
            return StopMethodMatcher.matchesNameDesc(methodTree, "valueOf", "(Ljava/lang/String;)" + returnTypeDescription) || StopMethodMatcher.matchesNameDesc(methodTree, "values", "()[" + returnTypeDescription) || StopMethodMatcher.matchesNameDesc(methodTree, "$values", "()[" + returnTypeDescription);
        };
    }

    static StopMethodMatcher isToString() {
        return StopMethodMatcher.forNameDesc("toString", "()Ljava/lang/String;");
    }

    static StopMethodMatcher isHashCode() {
        return StopMethodMatcher.forNameDesc("hashCode", "()I");
    }

    static StopMethodMatcher isDeprecated() {
        return (classTree, methodTree) -> StopMethodMatcher.matchesAccess(classTree, 131072) || StopMethodMatcher.matchesAccess(methodTree, 131072);
    }

    static StopMethodMatcher isEmptyVoid() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)177)));
    }

    static StopMethodMatcher isSynthetic() {
        return (classTree, methodTree) -> methodTree.isSynthetic() && !methodTree.rawNode().name.startsWith("lambda$");
    }

    static Match<AbstractInsnNode> opCodeBetween(int lower, int upper) {
        return (c, abstractInsnNode) -> {
            int opcode = abstractInsnNode.getOpcode();
            return opcode >= lower && opcode <= upper;
        };
    }

    static StopMethodMatcher isSimpleGetter() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)178)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(InstructionMatchers.opCode((int)180))).then(StopMethodMatchers.opCodeBetween(172, 177)));
    }

    static StopMethodMatcher isSimpleSetter() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(StopMethodMatchers.opCodeBetween(21, 25)).then(InstructionMatchers.opCode((int)181)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)21)).then(InstructionMatchers.opCode((int)179))).then(QueryStart.match((Match)InstructionMatchers.opCode((int)177)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(InstructionMatchers.opCode((int)176)))));
    }

    static StopMethodMatcher returnsAConstant() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match(StopMethodMatchers.opCodeBetween(1, 20)).then(StopMethodMatchers.opCodeBetween(172, 177)));
    }

    static StopMethodMatcher isDelegate() {
        SequenceQuery paramMatch = QueryStart.match(StopMethodMatchers.opCodeBetween(21, 45));
        Match<AbstractInsnNode> returnOpcode = StopMethodMatchers.opCodeBetween(172, 177);
        Match anyInvoke = (context, instructionNode) -> {
            int opcode = instructionNode.getOpcode();
            return opcode == 182 || opcode == 183 || opcode == 185;
        };
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)25).or(InstructionMatchers.opCode((int)178))).or(QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(InstructionMatchers.opCode((int)180))).zeroOrMore(paramMatch).then(anyInvoke).then(returnOpcode).or(paramMatch.zeroOrMore(paramMatch).then(InstructionMatchers.opCode((int)184)).then(returnOpcode)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)184)).then(returnOpcode)));
    }

    static StopMethodMatcher isStaticInitializer() {
        return StopMethodMatcher.forNameDesc("<clinit>", "()V");
    }

    static StopMethodMatcher returnsAnEmptyArray() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)3)).then(InstructionMatchers.opCode((int)188).or(InstructionMatchers.opCode((int)189))).then(InstructionMatchers.opCode((int)176)));
    }

    static StopMethodMatcher returnsNull() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)1)).then(InstructionMatchers.opCode((int)176)));
    }

    static StopMethodMatcher returnsThis() {
        Match ALOAD_0 = (context, instruction) -> {
            if (!(instruction instanceof VarInsnNode)) {
                return false;
            }
            return ((VarInsnNode)instruction).var == 0;
        };
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)ALOAD_0).then(InstructionMatchers.opCode((int)176)));
    }

    static StopMethodMatcher returnsAParameter() {
        Match ALOAD_X = (context, instruction) -> {
            if (!(instruction instanceof VarInsnNode)) {
                return false;
            }
            return ((VarInsnNode)instruction).var > 0;
        };
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)ALOAD_X).then(StopMethodMatchers.opCodeBetween(172, 176)));
    }

    static Match<AbstractInsnNode> aload(int var) {
        return (context, instruction) -> {
            if (!(instruction instanceof VarInsnNode)) {
                return false;
            }
            VarInsnNode node = (VarInsnNode)instruction;
            return node.getOpcode() == 25 && node.var == var;
        };
    }

    static StopMethodMatcher isKotlinGeneratedSetter() {
        Match<AbstractInsnNode> ALOAD_1 = StopMethodMatchers.aload(1);
        Match INVOKE_CHECK = (context, instruction) -> {
            if (!(instruction instanceof MethodInsnNode)) {
                return false;
            }
            MethodInsnNode node = (MethodInsnNode)instruction;
            return node.getOpcode() == 184 && node.name.equals("checkParameterIsNotNull") && node.owner.equals("kotlin/jvm/internal/Intrinsics") && node.desc.equals("(Ljava/lang/Object;Ljava/lang/String;)V");
        };
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match(ALOAD_1).then(InstructionMatchers.opCode((int)18)).then(INVOKE_CHECK).then(StopMethodMatchers.aload(0)).then(ALOAD_1).then(InstructionMatchers.opCode((int)181)).then(InstructionMatchers.opCode((int)177)));
    }
}

