/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators;

import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import eu.stamp_project.utils.TypeHelper;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.GeneratorAdapter;
import org.pitest.reloc.asm.commons.Method;

public class ConstantMutationOperator
extends MutationOperator {
    private final Object constant;
    private final String id;

    public ConstantMutationOperator(String id, Object constant) {
        if (!TypeHelper.isConstantType(constant.getClass())) {
            throw new IllegalArgumentException();
        }
        this.constant = constant;
        this.id = id;
    }

    public Object getConstant() {
        return this.constant;
    }

    @Override
    public boolean canMutate(MethodInfo method) {
        Type methodType = method.getReturnType();
        int typeSort = methodType.getSort();
        Type constantType = Type.getType(this.constant.getClass());
        if (typeSort == 9 || typeSort == 11) {
            return false;
        }
        if (typeSort == 10) {
            return constantType.equals((Object)methodType);
        }
        return methodType.equals((Object)constantType) || methodType.equals((Object)this.wrapperType());
    }

    @Override
    protected void generateCode(MethodInfo method, GeneratorAdapter mv) {
        mv.visitLdcInsn(this.constant);
        Type returnType = method.getReturnType();
        Type constantType = Type.getType(this.constant.getClass());
        if (this.constant.getClass() != String.class && returnType.equals((Object)constantType)) {
            String descriptor = String.format("(%s)L%s;", this.wrapperType().getInternalName(), returnType.getInternalName());
            Method valueOfMethod = new Method("valueOf", descriptor);
            mv.invokeStatic(returnType, valueOfMethod);
        }
        mv.returnValue();
    }

    private Type wrapperType() {
        return Type.getType(TypeHelper.unwrap(this.constant.getClass()));
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return "All method instructions replaced by: return " + this.id;
    }
}

