/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators;

import eu.stamp_project.descartes.annotations.Operator;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.GeneratorAdapter;

@Operator(identifier="empty", description="Method body replaced by instructions that returns an empty array of the corresponding type")
public class EmptyArrayMutationOperator
extends MutationOperator {
    @Override
    public boolean canMutate(MethodInfo method) {
        return method.getReturnType().getSort() == 9;
    }

    @Override
    protected void generateCode(MethodInfo method, GeneratorAdapter generator) {
        Type arrayType = method.getReturnType();
        for (int i = arrayType.getDimensions(); i > 0; --i) {
            generator.push(0);
        }
        Type lowerDimensionType = Type.getType((String)arrayType.getDescriptor().substring(1));
        generator.newArray(lowerDimensionType);
        generator.returnValue();
    }
}

