/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators;

import eu.stamp_project.descartes.annotations.Operator;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.ArgumentPropagationOperator;
import eu.stamp_project.descartes.operators.ConstantMutationOperator;
import eu.stamp_project.descartes.operators.EmptyArrayMutationOperator;
import eu.stamp_project.descartes.operators.InvalidOperatorException;
import eu.stamp_project.descartes.operators.NewInstanceMutationOperator;
import eu.stamp_project.descartes.operators.NullMutationOperator;
import eu.stamp_project.descartes.operators.OptionalMutationOperator;
import eu.stamp_project.descartes.operators.ThisMutationOperator;
import eu.stamp_project.descartes.operators.VoidMutationOperator;
import eu.stamp_project.descartes.operators.parsing.LiteralParser;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pitest.reloc.asm.commons.GeneratorAdapter;

public abstract class MutationOperator {
    private static final Class<?>[] PARAMETERLESS_OPERATORS = new Class[]{EmptyArrayMutationOperator.class, NewInstanceMutationOperator.class, NullMutationOperator.class, OptionalMutationOperator.class, VoidMutationOperator.class, ArgumentPropagationOperator.class, ThisMutationOperator.class};
    private static final Map<String, Class<?>> ID_2_CLASS = new HashMap(PARAMETERLESS_OPERATORS.length);

    public abstract boolean canMutate(MethodInfo var1);

    public void writeMutant(MethodInfo method, GeneratorAdapter code) {
        if (!this.canMutate(method)) {
            throw new IllegalArgumentException("Operator " + this.getIdentifier() + " can not mutate method " + method.getDescriptor());
        }
        this.generateCode(method, code);
    }

    protected abstract void generateCode(MethodInfo var1, GeneratorAdapter var2);

    public String getIdentifier() {
        return this.getClass().getAnnotation(Operator.class).identifier();
    }

    public String getDescription() {
        return this.getClass().getAnnotation(Operator.class).description();
    }

    public static MutationOperator fromID(String id) {
        if (ID_2_CLASS.containsKey(id = id.trim())) {
            Class<?> operatorClass = ID_2_CLASS.get(id);
            try {
                return (MutationOperator)operatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
                throw new AssertionError("Could not invoke default constructor for class " + operatorClass.getName(), exc);
            }
        }
        LiteralParser parser = new LiteralParser();
        LiteralParser.Result result = parser.parse(id);
        if (result.hasError()) {
            throw new InvalidOperatorException("Provided identifier \"" + id + "\" is not a valid mutation operator identidier.");
        }
        return new ConstantMutationOperator(id, result.getValue());
    }

    static {
        Arrays.stream(PARAMETERLESS_OPERATORS).forEach(opc -> ID_2_CLASS.put(opc.getAnnotation(Operator.class).identifier(), (Class<?>)opc));
    }
}

