/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators.parsing;

class TokenType {
    public static final int SYMBOL = 65536;
    public static final int MINUS_SIGN = 65537;
    public static final int LEFT_PARENTHESIS = 65538;
    public static final int RIGHT_PARENTHESIS = 65540;
    public static final int TYPE_IDENTIFIER = 131072;
    public static final int BYTE_TYPE = 131073;
    public static final int SHORT_TYPE = 131074;
    public static final int LITERAL = 262144;
    public static final int CHAR_LITERAL = 266240;
    public static final int STRING_LITERAL = 270336;
    public static final int BOOLEAN_LITERAL = 278528;
    public static final int FALSE = 278529;
    public static final int TRUE = 278530;
    public static final int NUMERIC_LITERAL = 294912;
    public static final int FLOAT_LITERAL = 295424;
    public static final int DOUBLE_LITERAL = 295936;
    public static final int INTEGRAL_LITERAL = 296960;
    public static final int BYTE_LITERAL = 296992;
    public static final int BYTE_BIN_LITERAL = 296994;
    public static final int BYTE_OCT_LITERAL = 297000;
    public static final int BYTE_DEC_LITERAL = 297002;
    public static final int BYTE_HEX_LITERAL = 297008;
    public static final int SHORT_LITERAL = 297024;
    public static final int SHORT_BIN_LITERAL = 297026;
    public static final int SHORT_OCT_LITERAL = 297032;
    public static final int SHORT_DEC_LITERAL = 297034;
    public static final int SHORT_HEX_LITERAL = 297040;
    public static final int INTEGER_LITERAL = 297088;
    public static final int INTEGER_BIN_LITERAL = 297090;
    public static final int INTEGER_OCT_LITERAL = 297096;
    public static final int INTEGER_DEC_LITERAL = 297098;
    public static final int INTEGER_HEX_LITERAL = 297104;
    public static final int LONG_LITERAL = 297216;
    public static final int LONG_BIN_LITERAL = 297218;
    public static final int LONG_OCT_LITERAL = 297224;
    public static final int LONG_DEC_LITERAL = 297226;
    public static final int LONG_HEX_LITERAL = 297232;
    public static final int END_OF_FILE = 0x100000;

    private TokenType() {
    }

    public static boolean is(int token, int category) {
        return (token & category) == category;
    }

    public static int typeToLiteral(int tokenType) {
        if (TokenType.is(tokenType, 131074)) {
            return 297024;
        }
        if (TokenType.is(tokenType, 131073)) {
            return 296992;
        }
        throw new IllegalArgumentException("Expecting type identifier token types");
    }

    public static Class<?> getNumericType(int tokenType) {
        if (TokenType.is(tokenType, 131073) || TokenType.is(tokenType, 296992)) {
            return Byte.class;
        }
        if (TokenType.is(tokenType, 131074) || TokenType.is(tokenType, 297024)) {
            return Short.class;
        }
        if (TokenType.is(tokenType, 297088)) {
            return Integer.class;
        }
        if (TokenType.is(tokenType, 297216)) {
            return Long.class;
        }
        if (TokenType.is(tokenType, 295424)) {
            return Float.class;
        }
        if (TokenType.is(tokenType, 295936)) {
            return Double.class;
        }
        throw new IllegalArgumentException("Token type must represent a numeric literal or a type identifier");
    }

    public static int getRadix(int tokenType) {
        if (!TokenType.is(tokenType, 296960)) {
            throw new IllegalArgumentException("Only integral literals have radix");
        }
        return tokenType & 0x1F;
    }
}

