/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.BaseActionPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionServiceContainerImpl
implements ActionServiceContainer,
Startable {
    private static final String ACTIONABLE = "exo:actionable";
    private static final String ACTION = "exo:action";
    private static final String JOB_NAME_PROP = "exo:jobName";
    private static final String JOB_GROUP_PROP = "exo:jobGroup";
    private static final String JOB_CLASS_PROP = "exo:jobClass";
    private static final String LIFECYCLE_PHASE_PROP = "exo:lifecyclePhase";
    private static final String ACTION_QUERY = "//element(*, exo:action)";
    private static final String SCHEDULABLE_MIXIN = "exo:schedulableInfo";
    private RepositoryService repositoryService_;
    private String workspace_;
    private CmsService cmsService_;
    private Collection<ComponentPlugin> actionPlugins = new ArrayList<ComponentPlugin>();

    public ActionServiceContainerImpl(InitParams params, RepositoryService repositoryService, CmsService cmsService) throws Exception {
        this.repositoryService_ = repositoryService;
        this.cmsService_ = cmsService;
        this.workspace_ = params.getValueParam("workspace").getValue();
    }

    public Collection<String> getActionPluginNames() {
        ArrayList<String> actionPluginNames = new ArrayList<String>();
        for (ComponentPlugin plugin : this.actionPlugins) {
            actionPluginNames.add(plugin.getName());
        }
        return actionPluginNames;
    }

    public ActionPlugin getActionPlugin(String actionsServiceName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(actionsServiceName)) continue;
            return (ActionPlugin)plugin;
        }
        return null;
    }

    public void createActionType(String actionTypeName, String parentActionTypeName, String executable, List<String> variableNames, boolean isMoveType) throws Exception {
        NodeTypeValue nodeTypeValue = new NodeTypeValue();
        nodeTypeValue.setName(actionTypeName);
        ArrayList<String> superTypes = new ArrayList<String>();
        superTypes.add(parentActionTypeName);
        if (isMoveType) {
            superTypes.add("exo:move");
        }
        nodeTypeValue.setDeclaredSupertypeNames(superTypes);
        ArrayList<PropertyDefinitionValue> propDefs = new ArrayList<PropertyDefinitionValue>();
        PropertyDefinitionValue propDef = null;
        for (String variableName : variableNames) {
            propDef = this.createPropertyDef(variableName);
            propDefs.add(propDef);
        }
        propDef = this.createPropertyDef(this.getActionPluginForActionType(parentActionTypeName).getExecutableDefinitionName());
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.add(executable);
        propDef.setDefaultValueStrings(defaultValues);
        propDef.setMandatory(false);
        propDefs.add(propDef);
        nodeTypeValue.setDeclaredPropertyDefinitionValues(propDefs);
        nodeTypeValue.setDeclaredChildNodeDefinitionValues(new ArrayList());
        ExtendedNodeTypeManager ntmanager = this.repositoryService_.getRepository().getNodeTypeManager();
        ntmanager.registerNodeType(nodeTypeValue, 0);
    }

    private PropertyDefinitionValue createPropertyDef(String name) {
        PropertyDefinitionValue def = new PropertyDefinitionValue();
        def.setName(name);
        def.setRequiredType(1);
        def.setMandatory(false);
        def.setMultiple(false);
        def.setReadOnly(false);
        def.setAutoCreate(false);
        def.setOnVersion(1);
        def.setValueConstraints(new ArrayList());
        def.setDefaultValueStrings(new ArrayList());
        return def;
    }

    public Collection<NodeType> getCreatedActionTypes() throws Exception {
        ArrayList<NodeType> createsActions = new ArrayList<NodeType>();
        Session session = this.getSystemSession(this.workspace_);
        NodeTypeManager ntmanager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator iter = ntmanager.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = (NodeType)iter.next();
            String name = nt.getName();
            if (!this.extendsBaseAction(nt) || this.isAbstractType(name)) continue;
            createsActions.add(nt);
        }
        return createsActions;
    }

    private boolean isAbstractType(String name) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean extendsBaseAction(NodeType nt) {
        NodeType[] superTypes;
        for (NodeType type : superTypes = nt.getSupertypes()) {
            if (!ACTION.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    private Session getSystemSession(String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository();
        return jcrRepository.getSystemSession(workspace);
    }

    public ActionPlugin getActionPluginForActionType(String actionTypeName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName) && !actionServiceName.equals(actionTypeName)) continue;
            return actionService;
        }
        return null;
    }

    public Node getAction(Node node, String actionName) throws Exception {
        String wsName = node.getSession().getWorkspace().getName();
        Session session = this.repositoryService_.getRepository().getSystemSession(wsName);
        Node action = (Node)session.getItem(node.getPath() + "/" + actionName);
        return action;
    }

    public Node getInitAction(Node node, String actionName) throws Exception {
        return node.getNode(actionName);
    }

    public boolean hasActions(Node node) throws Exception {
        return node.isNodeType(ACTIONABLE);
    }

    public List<Node> getActions(Node node) throws Exception {
        return this.getActions(node, null);
    }

    public List<Node> getActions(Node node, String lifecyclePhase) throws Exception {
        ArrayList<Node> actions = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node tmpNode = iter.nextNode();
            if (!tmpNode.isNodeType(ACTION) || lifecyclePhase != null && !lifecyclePhase.equals(tmpNode.getProperty(LIFECYCLE_PHASE_PROP).getString())) continue;
            actions.add(tmpNode);
        }
        return actions;
    }

    public void removeAction(Node node, String actionName) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        Node action2Remove = node.getNode(actionName);
        String lifecyclePhase = action2Remove.getProperty(LIFECYCLE_PHASE_PROP).getString();
        String jobName = null;
        String jobGroup = null;
        String jobClassName = null;
        if (action2Remove.isNodeType(SCHEDULABLE_MIXIN)) {
            jobName = action2Remove.getProperty(JOB_NAME_PROP).getString();
            jobGroup = action2Remove.getProperty(JOB_GROUP_PROP).getString();
            jobClassName = action2Remove.getProperty(JOB_CLASS_PROP).getString();
        }
        String actionTypeName = action2Remove.getPrimaryNodeType().getName();
        String actionPath = action2Remove.getPath();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName)) continue;
            if (lifecyclePhase.equals("schedule")) {
                actionService.removeActivationJob(jobName, jobGroup, jobClassName);
                continue;
            }
            actionService.removeObservation(actionPath);
        }
        action2Remove.remove();
        node.save();
    }

    public void addAction(Node storeActionNode, String actionType, Map mappings) throws Exception {
        if (!storeActionNode.isNodeType(ACTIONABLE)) {
            storeActionNode.addMixin(ACTIONABLE);
            storeActionNode.save();
        }
        String newActionPath = this.cmsService_.storeNode(actionType, storeActionNode, mappings, true);
        storeActionNode.save();
        String srcWorkspace = storeActionNode.getSession().getWorkspace().getName();
        String srcPath = storeActionNode.getPath();
        ActionPlugin actionService = this.getActionPluginForActionType(actionType);
        if (actionService == null) {
            throw new ClassNotFoundException("Not found any action's service compatible with action type" + actionType);
        }
        try {
            actionService.addAction(actionType, srcWorkspace, srcPath, mappings);
        }
        catch (Exception e) {
            String workspace = StringUtils.substringBefore((String)newActionPath, (String)":");
            String nodePath = StringUtils.substringAfter((String)newActionPath, (String)":");
            Session session = this.getSystemSession(workspace);
            Node actionNode = (Node)session.getItem(nodePath);
            actionNode.remove();
            session.save();
        }
    }

    public void executeAction(String userId, Node node, String actionName) throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("initiator", userId);
        variables.put("actionName", actionName);
        variables.put("nodePath", node.getPath());
        variables.put("srcWorkspace", node.getSession().getWorkspace().getName());
        variables.put("srcPath", node.getParent().getPath());
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        variables.put("document-type", nodeTypeName);
        Node actionNode = node.getNode(actionName);
        NodeType actionNodeType = actionNode.getPrimaryNodeType();
        this.fillVariables(actionNode, actionNodeType, variables);
        NodeType[] actionMixinTypes = actionNode.getMixinNodeTypes();
        for (int i = 0; i < actionMixinTypes.length; ++i) {
            NodeType mixinType = actionMixinTypes[i];
            this.fillVariables(actionNode, mixinType, variables);
        }
        this.executeAction(userId, node, actionName, variables);
    }

    private void fillVariables(Node actionNode, NodeType nodeType, Map variables) throws Exception {
        PropertyDefinition[] propDefs = nodeType.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition def = propDefs[i];
            String propName = def.getName();
            if (!actionNode.hasProperty(propName)) continue;
            String propValue = actionNode.getProperty(propName).getString();
            variables.put(propName, propValue);
        }
    }

    public void executeAction(String userId, Node node, String actionName, Map variables) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        Node actionNode = node.getNode(actionName);
        String actionTypeName = actionNode.getPrimaryNodeType().getName();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionPlugin = this.getActionPlugin(actionServiceName);
            if (!actionPlugin.isActionTypeSupported(actionTypeName)) continue;
            actionPlugin.executeAction(userId, actionNode, variables);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        this.actionPlugins.add(plugin);
    }

    public ComponentPlugin removePlugin(String pluginName) {
        return null;
    }

    public Collection getPlugins() {
        return this.actionPlugins;
    }

    private void initiateActionConfiguration() throws Exception {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository();
        String[] workspaces = jcrRepository.getWorkspaceNames();
        String workspace = null;
        for (int i = 0; i < workspaces.length; ++i) {
            workspace = workspaces[i];
            Session session = jcrRepository.getSystemSession(workspace);
            QueryManager queryManager = null;
            try {
                queryManager = session.getWorkspace().getQueryManager();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (queryManager == null) continue;
            try {
                Query query = queryManager.createQuery(ACTION_QUERY, "xpath");
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node actionNode = iter.nextNode();
                    String lifecyclePhase = actionNode.getProperty(LIFECYCLE_PHASE_PROP).getString();
                    String actionType = actionNode.getPrimaryNodeType().getName();
                    for (ComponentPlugin plugin : this.actionPlugins) {
                        String actionServiceName = plugin.getName();
                        ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                        if (!actionService.isActionTypeSupported(actionType)) continue;
                        if (lifecyclePhase.equals("schedule")) {
                            actionService.reScheduleActivations(actionNode);
                            continue;
                        }
                        actionService.initiateActionObservation(actionNode);
                    }
                }
                continue;
            }
            catch (Exception e) {
                System.out.println(">>>> Can not launch action listeners for wokrpsace: " + workspace);
            }
        }
    }

    public void initiateObservation(Node node) throws Exception {
        try {
            Session session = node.getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String queryStr = node.getPath() != "/" ? "/jcr:root" + node.getPath() + ACTION_QUERY : ACTION_QUERY;
            Query query = queryManager.createQuery(queryStr, "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node actionNode = iter.nextNode();
                try {
                    String actionType = actionNode.getPrimaryNodeType().getName();
                    for (ComponentPlugin plugin : this.actionPlugins) {
                        String actionServiceName = plugin.getName();
                        ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                        if (!actionService.isActionTypeSupported(actionType)) continue;
                        actionService.initiateActionObservation(actionNode);
                    }
                }
                catch (Exception e) {
                    System.out.println("Can not launch action listeners named is " + actionNode.getPath());
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Can not launch action listeners inside " + node.getPath() + " node.");
        }
    }

    public void start() {
        try {
            for (BaseActionPlugin baseActionPlugin : this.actionPlugins) {
                baseActionPlugin.importPredefinedActionsInJcr();
            }
            this.initiateActionConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }
}

