/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionConfig;
import org.exoplatform.services.cms.actions.BaseActionLauncherListener;
import org.exoplatform.services.cms.actions.BaseActionPlugin;
import org.exoplatform.services.cms.actions.ECMEventListener;
import org.exoplatform.services.cms.actions.activation.BPActionActivationJob;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.WorkflowServiceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPActionPlugin
extends BaseActionPlugin
implements ComponentPlugin {
    public static final String ACTION_TYPE = "exo:businessProcessAction";
    private WorkflowServiceContainer workflowServiceContainer_;
    private ActionConfig config_;
    private RepositoryService repositoryService_;

    public BPActionPlugin(RepositoryService repositoryService, InitParams params, WorkflowServiceContainer workflowServiceContainer) throws Exception {
        this.workflowServiceContainer_ = workflowServiceContainer;
        this.repositoryService_ = repositoryService;
        this.config_ = (ActionConfig)params.getObjectParamValues(ActionConfig.class).get(0);
    }

    public Collection<String> getActionExecutables() throws Exception {
        List processes = this.workflowServiceContainer_.getProcesses();
        ArrayList<String> businessProcesses = new ArrayList<String>();
        ListIterator iter = processes.listIterator();
        while (iter.hasNext()) {
            Process process = (Process)iter.next();
            businessProcesses.add(process.getName());
        }
        return businessProcesses;
    }

    public String getActionExecutableLabel() {
        return "Business Processes:";
    }

    @Override
    protected ECMEventListener createEventListener(String actionName, String moveExecutable, String srcWorkspace, String srcPath, Map variables) throws Exception {
        return new BPActionLauncherListener(actionName, moveExecutable, srcWorkspace, srcPath, variables);
    }

    public String getExecutableDefinitionName() {
        return "exo:businessProcess";
    }

    @Override
    protected String getWorkspace() {
        return this.config_.getWorkspace();
    }

    @Override
    protected ManageableRepository getRepository() throws Exception {
        return this.repositoryService_.getRepository();
    }

    @Override
    protected String getActionType() {
        return ACTION_TYPE;
    }

    @Override
    protected List getActions() {
        return this.config_.getActions();
    }

    public String getName() {
        return ACTION_TYPE;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return "Add an action service";
    }

    public void setDescription(String desc) {
    }

    public void executeAction(String userId, Node actionNode, Map variables) throws Exception {
        String businessProcess = actionNode.getProperty("exo:businessProcess").getString();
        this.executeAction(userId, businessProcess, variables);
    }

    public void executeAction(String userId, String executable, Map variables) {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        WorkflowServiceContainer workflowSContainer = (WorkflowServiceContainer)exoContainer.getComponentInstanceOfType(WorkflowServiceContainer.class);
        workflowSContainer.startProcessFromName(userId, executable, variables);
    }

    public void activateAction(String userId, String executable, Map variables) throws Exception {
        this.executeAction(userId, executable, variables);
    }

    @Override
    protected Class createActivationJob() throws Exception {
        return BPActionActivationJob.class;
    }

    public class BPActionLauncherListener
    extends BaseActionLauncherListener {
        public BPActionLauncherListener(String actionName, String businessProcess, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
            super(actionName, businessProcess, srcWorkspace, srcPath, actionVariables);
        }

        public void triggerAction(String userId, Map variables) {
            BPActionPlugin.this.executeAction(userId, this.executable_, variables);
        }
    }
}

