/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.categories;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.Workspace;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.cms.categories.TaxonomyConfig;
import org.exoplatform.services.cms.categories.TaxonomyPlugin;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesServiceImpl
implements CategoriesService,
Startable {
    private static final String CATEGORY_MIXIN = "exo:categorized";
    private static final String CATEGORY_PROP = "exo:category";
    private static final String COPY = "copy";
    private static final String CUT = "cut";
    private RepositoryService repositoryService_;
    private CmsConfigurationService cmsConfig_;
    private String taxonomyHomePath_;
    List<TaxonomyPlugin> plugins_ = new ArrayList<TaxonomyPlugin>();

    public CategoriesServiceImpl(RepositoryService repositoryService, CmsConfigurationService cmsConfig) throws Exception {
        this.repositoryService_ = repositoryService;
        this.cmsConfig_ = cmsConfig;
        this.taxonomyHomePath_ = cmsConfig.getJcrPath("exoTaxonomiesPath");
    }

    public void addTaxonomyPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TaxonomyPlugin) {
            this.plugins_.add((TaxonomyPlugin)plugin);
        }
    }

    public Node getTaxonomyHomeNode() throws Exception {
        Session adminSession = this.getAdminSession();
        Node homeTaxonomy = (Node)adminSession.getItem(this.taxonomyHomePath_);
        return homeTaxonomy;
    }

    public Node getTaxonomyNode(String realPath) throws Exception {
        Session adminSession = this.getAdminSession();
        return (Node)adminSession.getItem(realPath);
    }

    public void addTaxonomy(String parentPath, String childName) throws Exception {
        Session adminSession = this.getAdminSession();
        Node parent = (Node)adminSession.getItem(parentPath);
        if (parent.hasNode(childName)) {
            throw new ItemExistsException();
        }
        Node taxonomyNode = parent.addNode(childName, "exo:taxonomy");
        if (taxonomyNode.canAddMixin("mix:referenceable")) {
            taxonomyNode.addMixin("mix:referenceable");
        }
        adminSession.save();
    }

    public void removeTaxonomyNode(String realPath) throws Exception {
        Session adminSession = this.getAdminSession();
        Node selectedNode = (Node)adminSession.getItem(realPath);
        selectedNode.remove();
        adminSession.save();
        adminSession.refresh(false);
    }

    public void moveTaxonomyNode(String srcPath, String destPath, String type) throws Exception {
        Session session = this.getSystemSession();
        if (CUT.equals(type)) {
            session.move(srcPath, destPath);
            session.save();
            session.refresh(true);
        } else if (COPY.equals(type)) {
            Workspace workspace = session.getWorkspace();
            workspace.copy(srcPath, destPath);
            session.save();
            session.refresh(true);
        } else {
            throw new UnsupportedRepositoryOperationException();
        }
    }

    private void init() throws Exception {
        Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfig_.getWorkspace());
        Node taxonomyHomeNode = (Node)session.getItem(this.taxonomyHomePath_);
        for (TaxonomyPlugin plugin : this.plugins_) {
            List<TaxonomyConfig.Taxonomy> taxonomies = plugin.getTaxonomies();
            for (TaxonomyConfig.Taxonomy taxonomy : taxonomies) {
                Node taxonomyNode = Utils.makePath(taxonomyHomeNode, taxonomy.getPath(), "exo:taxonomy");
                if (taxonomyNode.canAddMixin("mix:referenceable")) {
                    taxonomyNode.addMixin("mix:referenceable");
                }
                session.save();
                session.refresh(true);
            }
        }
    }

    public boolean hasCategories(Node node) throws Exception {
        return node.isNodeType(CATEGORY_MIXIN);
    }

    public List<Node> getCategories(Node node) throws Exception {
        ArrayList<Node> cats = new ArrayList<Node>();
        Session systemSession = this.getSystemSession();
        try {
            Property categories = node.getProperty(CATEGORY_PROP);
            Value[] values = categories.getValues();
            for (int i = 0; i < values.length; ++i) {
                cats.add(systemSession.getNodeByUUID(values[i].getString()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cats;
    }

    public void removeCategory(Node node, String categoryPath) throws Exception {
        Session systemSession = this.getSystemSession();
        ArrayList<Value> vals = new ArrayList<Value>();
        if (!"*".equals(categoryPath)) {
            Property categories = node.getProperty(CATEGORY_PROP);
            Value[] values = categories.getValues();
            String uuid2Remove = null;
            for (int i = 0; i < values.length; ++i) {
                String uuid = values[i].getString();
                Node refNode = systemSession.getNodeByUUID(uuid);
                if (refNode.getPath().equals(categoryPath)) {
                    uuid2Remove = uuid;
                    continue;
                }
                vals.add(values[i]);
            }
            if (uuid2Remove == null) {
                return;
            }
        }
        node.setProperty(CATEGORY_PROP, vals.toArray(new Value[vals.size()]));
        node.getSession().save();
    }

    public void addCategory(Node node, String categoryPath) throws Exception {
        Session systemSession = this.getSystemSession();
        Node catNode = (Node)systemSession.getItem(categoryPath);
        Session currentSession = node.getSession();
        Value value2add = currentSession.getValueFactory().createValue(catNode);
        if (!node.isNodeType(CATEGORY_MIXIN)) {
            node.addMixin(CATEGORY_MIXIN);
            node.setProperty(CATEGORY_PROP, new Value[]{value2add});
        } else {
            ArrayList<Value> vals = new ArrayList<Value>();
            Value[] values = node.getProperty(CATEGORY_PROP).getValues();
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = systemSession.getNodeByUUID(uuid);
                if (refNode.getPath().equals(categoryPath)) {
                    return;
                }
                vals.add(value);
            }
            vals.add(value2add);
            node.setProperty(CATEGORY_PROP, vals.toArray(new Value[vals.size()]));
        }
    }

    public void addCategory(Node node, String categoryPath, boolean replaceAll) throws Exception {
        if (replaceAll) {
            this.removeCategory(node, "*");
        }
        this.addCategory(node, categoryPath);
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    protected Session getSystemSession() throws Exception {
        Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfig_.getWorkspace());
        return session;
    }

    protected Session getAdminSession() throws Exception {
        Session session;
        try {
            session = this.repositoryService_.getRepository().login(this.cmsConfig_.getWorkspace());
        }
        catch (Exception e) {
            session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfig_.getWorkspace());
        }
        return session;
    }
}

