/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.picocontainer.Startable;

public abstract class BaseResourceLoaderService
implements Startable {
    protected CmsConfigurationService cmsConfigService_;
    protected ResourceConfig config_;
    protected RepositoryService repositoryService_;
    protected ConfigurationManager cservice_;
    protected ExoCache resourceCache_;

    public BaseResourceLoaderService(ResourceConfig resourceConfig, ConfigurationManager cservice, CmsConfigurationService cmsConfigService, RepositoryService repositoryService, CacheService cacheService) throws Exception {
        this.cmsConfigService_ = cmsConfigService;
        this.config_ = resourceConfig;
        this.repositoryService_ = repositoryService;
        this.cservice_ = cservice;
        this.resourceCache_ = cacheService.getCacheInstance(this.getClass().getName());
    }

    protected abstract String getBasePath();

    protected abstract void removeFromCache(String var1);

    protected Session getSystemSession(String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository();
        return jcrRepository.getSystemSession(workspace);
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    protected void init(ResourceConfig resourceConfig) throws Exception {
        ResourceConfig config = this.config_;
        this.config_ = resourceConfig;
        this.init();
        this.config_ = config;
    }

    protected void init() throws Exception {
        Session session = null;
        try {
            session = this.getSystemSession(this.config_.getWorkspace());
        }
        catch (RepositoryException re) {
            return;
        }
        String resourcesPath = this.getBasePath();
        List resources = this.config_.getRessources();
        if (resources.size() == 0) {
            return;
        }
        try {
            String firstResourceName = ((ResourceConfig.Resource)resources.get(0)).getName();
            session.getItem(resourcesPath + "/" + firstResourceName);
            return;
        }
        catch (PathNotFoundException e) {
            Node root = session.getRootNode();
            Node resourcesHome = (Node)session.getItem(resourcesPath);
            String warPath = this.cmsConfigService_.getContentLocation() + "/system" + resourcesPath.substring(resourcesPath.lastIndexOf("/"));
            for (ResourceConfig.Resource resource : resources) {
                String name = resource.getName();
                String path = warPath + "/" + name;
                InputStream in = this.cservice_.getInputStream(path);
                this.addResource(resourcesHome, name, in);
            }
            root.save();
            session.save();
            return;
        }
    }

    private void addResource(Node resourcesHome, String resourceName, InputStream in) throws Exception {
        Node contentNode = null;
        if (resourceName.lastIndexOf("/") > -1) {
            Node parentResource;
            String realParenPath = StringUtils.substringBeforeLast((String)resourceName, (String)"/");
            resourcesHome = parentResource = resourcesHome.getNode(realParenPath);
            resourceName = StringUtils.substringAfterLast((String)resourceName, (String)"/");
        }
        try {
            contentNode = resourcesHome.getNode(resourceName);
        }
        catch (PathNotFoundException e) {
            contentNode = resourcesHome.addNode(resourceName, "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:mimeType", "text/xml");
        }
        contentNode.setProperty("jcr:data", in);
        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        resourcesHome.save();
    }

    protected Node getResourcesHome() throws Exception {
        Session session = null;
        try {
            session = this.getSystemSession(this.config_.getWorkspace());
        }
        catch (RepositoryException re) {
            return null;
        }
        String resourcesPath = this.getBasePath();
        return (Node)session.getItem(resourcesPath);
    }

    public String getResourceAsText(String resourceName) throws Exception {
        Node resourcesHome = this.getResourcesHome();
        Node resourceNode = resourcesHome.getNode(resourceName);
        return resourceNode.getProperty("jcr:data").getString();
    }

    public NodeIterator getResources() throws Exception {
        Node resourcesHome = this.getResourcesHome();
        return resourcesHome.getNodes();
    }

    public boolean hasResources() throws Exception {
        Node resourcesHome = this.getResourcesHome();
        return resourcesHome.hasNodes();
    }

    public void addResource(String name, String text) throws Exception {
        Node resourcesHome = this.getResourcesHome();
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        this.addResource(resourcesHome, name, in);
        resourcesHome.save();
    }

    public void removeResource(String resourceName) throws Exception {
        this.removeFromCache(resourceName);
        Node resourcesHome = this.getResourcesHome();
        Node resource2remove = resourcesHome.getNode(resourceName);
        resource2remove.remove();
        resourcesHome.save();
    }
}

