/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.AddPathPlugin;
import org.exoplatform.services.cms.impl.CmsConfig;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.picocontainer.Startable;

public class CmsConfigurationServiceImpl
implements CmsConfigurationService,
Startable {
    private RepositoryService jcrService_;
    List<AddPathPlugin> plugins_;
    private PropertiesParam propertiesParam_;

    public CmsConfigurationServiceImpl(InitParams params, RepositoryService jcrService) throws Exception {
        this.jcrService_ = jcrService;
        this.plugins_ = new ArrayList<AddPathPlugin>();
        this.propertiesParam_ = params.getPropertiesParam("cms.configuration");
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    private void init() throws Exception {
        ManageableRepository jcrRepository = this.jcrService_.getRepository();
        HashMap<String, String[]> permissions = null;
        for (int j = 0; j < this.plugins_.size(); ++j) {
            CmsConfig config = this.plugins_.get(j).getPaths();
            List jcrPaths = config.getJcrPaths();
            for (CmsConfig.JcrPath jcrPath : jcrPaths) {
                List workspaces = jcrPath.getWorkspaces();
                for (CmsConfig.Workspace workspace : workspaces) {
                    Session session = jcrRepository.getSystemSession(workspace.getName());
                    permissions = new HashMap<String, String[]>();
                    List perms = workspace.getPermissions();
                    for (CmsConfig.Permission perm : perms) {
                        ArrayList<String> permsList = new ArrayList<String>();
                        if ("true".equals(perm.getRead())) {
                            permsList.add("read");
                        }
                        if ("true".equals(perm.getAddNode())) {
                            permsList.add("add_node");
                        }
                        if ("true".equals(perm.getSetProperty())) {
                            permsList.add("set_property");
                        }
                        if ("true".equals(perm.getRemove())) {
                            permsList.add("remove");
                        }
                        String[] permsArray = new String[permsList.size()];
                        permissions.put(perm.getOwner(), permsList.toArray(permsArray));
                    }
                    Utils.makePath(session.getRootNode(), jcrPath.getPath(), "nt:unstructured", permissions);
                    session.save();
                }
            }
        }
    }

    public String getWorkspace() {
        return this.propertiesParam_.getProperty("workspace");
    }

    public String getDraftWorkspace() {
        return this.propertiesParam_.getProperty("draft");
    }

    public String getBackupWorkspace() {
        return this.propertiesParam_.getProperty("backup");
    }

    public String getContentLocation() {
        return this.propertiesParam_.getProperty("contentLocation");
    }

    public String getJcrPath(String alias) {
        for (int j = 0; j < this.plugins_.size(); ++j) {
            CmsConfig config = this.plugins_.get(j).getPaths();
            List jcrPaths = config.getJcrPaths();
            for (CmsConfig.JcrPath jcrPath : jcrPaths) {
                if (!jcrPath.getAlias().equals(alias)) continue;
                return jcrPath.getPath();
            }
        }
        return null;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddPathPlugin) {
            this.plugins_.add((AddPathPlugin)plugin);
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return null;
    }
}

