/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.NewUserConfig;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;

public class NewUserListener
extends UserEventListener {
    private static final String[] perms = new String[]{"read", "add_node", "set_property", "remove"};
    private NewUserConfig config_;
    private ConfigurationManager cservice_;
    private Collection localeConfigs_;
    private RepositoryService jcrService_;
    private Log log_;
    private CmsConfigurationService cmsConfigurationService_;
    private String relativePath_;

    public NewUserListener(ConfigurationManager cservice, LocaleConfigService localeService, RepositoryService jcrService, CmsConfigurationService cmsConfigurationService, LogService logService, InitParams params) throws Exception {
        this.cservice_ = cservice;
        this.jcrService_ = jcrService;
        this.cmsConfigurationService_ = cmsConfigurationService;
        this.log_ = logService.getLog(((Object)((Object)this)).getClass().getName());
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
        this.localeConfigs_ = localeService.getLocalConfigs();
        this.relativePath_ = params.getValueParam("relativePath").getValue();
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String userName = user.getUserName();
        this.prepareSystemWorkspace(userName);
        this.prepareWorkpsace(this.cmsConfigurationService_.getDraftWorkspace(), userName);
        this.prepareWorkpsace(this.cmsConfigurationService_.getBackupWorkspace(), userName);
    }

    private void prepareSystemWorkspace(String userName) throws Exception {
        ManageableRepository jcrRepository = this.jcrService_.getRepository();
        Session session = null;
        try {
            session = jcrRepository.getSystemSession(this.cmsConfigurationService_.getWorkspace());
        }
        catch (RepositoryException re) {
            return;
        }
        Node usersHome = (Node)session.getItem(this.cmsConfigurationService_.getJcrPath("usersPath"));
        Node siteHome = Utils.makePath(usersHome, userName + "/" + this.relativePath_, "nt:unstructured", this.getPermissions(userName));
        List users = this.config_.getUsers();
        boolean userFound = false;
        NewUserConfig.User templateConfig = null;
        for (NewUserConfig.User userConfig : users) {
            String currentName = userConfig.getUserName();
            if (this.config_.getTemplate().equals(currentName)) {
                templateConfig = userConfig;
            }
            if (!currentName.equals(userName)) continue;
            List files = userConfig.getReferencedFiles();
            this.importLocalisedContent(siteHome, currentName, files);
            userFound = true;
            break;
        }
        if (!userFound && templateConfig != null) {
            List files = templateConfig.getReferencedFiles();
            this.importLocalisedContent(siteHome, templateConfig.getUserName(), files);
        }
        usersHome.save();
    }

    private void prepareWorkpsace(String workspace, String userName) throws Exception {
        Session session = null;
        try {
            ManageableRepository jcrRepository = this.jcrService_.getRepository();
            session = jcrRepository.getSystemSession(workspace);
        }
        catch (RepositoryException re) {
            return;
        }
        Node usersHome = (Node)session.getItem(this.cmsConfigurationService_.getJcrPath("usersPath"));
        Node siteHome = Utils.makePath(usersHome, userName + "/" + this.relativePath_, "nt:unstructured", this.getPermissions(userName));
        for (LocaleConfig localeConfig : this.localeConfigs_) {
            String locale = localeConfig.getLanguage();
            if (siteHome.hasNode(locale)) continue;
            siteHome.addNode(locale);
        }
        usersHome.save();
    }

    public Map getPermissions(String owner) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put(owner, perms);
        permissions.put("any", new String[]{"read"});
        permissions.put("*:/admin", perms);
        return permissions;
    }

    private void importLocalisedContent(Node siteHome, String userName, List files) throws Exception {
        for (LocaleConfig localeConfig : this.localeConfigs_) {
            String locale = localeConfig.getLanguage();
            Node localisedNode = siteHome.hasNode(locale) ? siteHome.getNode(locale) : siteHome.addNode(locale);
            this.importInJCR(files, localisedNode, locale, userName);
        }
    }

    private void importInJCR(List files, Node localizedHome, String locale, String userName) {
        for (String file : files) {
            String folderPath = file.substring(0, file.lastIndexOf("/"));
            if ("".equals(folderPath)) {
                folderPath = "/";
            } else if (!"/".equals(folderPath.substring(0, 0))) {
                folderPath = "/" + folderPath;
            }
            String fileName = file.substring(file.lastIndexOf("/") + 1);
            String warPath = this.cmsConfigurationService_.getContentLocation() + this.cmsConfigurationService_.getJcrPath("usersPath") + "/" + userName + "/" + locale + folderPath + fileName;
            try {
                InputStream iS = this.cservice_.getInputStream(warPath);
                Node parentFileNode = Utils.makePath(localizedHome, folderPath, "nt:folder");
                Node realFileNode = parentFileNode.addNode(fileName, "nt:file");
                Node contentNode = realFileNode.addNode("jcr:content", "nt:resource");
                contentNode.setProperty("jcr:encoding", "UTF-8");
                contentNode.setProperty("jcr:data", iS);
                contentNode.setProperty("jcr:mimeType", "text/html");
                contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar(new Locale(locale)));
            }
            catch (Exception e1) {}
        }
    }

    public void preDelete(User user) {
        try {
            ManageableRepository jcrRepository = this.jcrService_.getRepository();
            Session session = jcrRepository.login();
            Node usersHome = (Node)session.getItem(this.cmsConfigurationService_.getJcrPath("usersPath"));
            usersHome.getNode(user.getUserName()).remove();
            usersHome.save();
            session = jcrRepository.login(this.cmsConfigurationService_.getDraftWorkspace());
            usersHome = (Node)session.getItem(this.cmsConfigurationService_.getJcrPath("usersPath"));
            usersHome.getNode(user.getUserName()).remove();
            usersHome.save();
        }
        catch (PathNotFoundException ex) {
            this.log_.info((Object)("Can not delete home dir of user " + user.getUserName()));
        }
        catch (RepositoryException e) {
            this.log_.error((Object)"RepositoryException while trying to delete a user home dir", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            this.log_.error((Object)"RepositoryException while trying to delete a user home dir", (Throwable)e);
        }
    }
}

