/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.queries.QueryData;
import org.exoplatform.services.jcr.RepositoryService;

public class QueryPlugin
extends BaseComponentPlugin {
    private static String STATEMENT = "jcr:statement".intern();
    private static String LANGUAGE = "jcr:language".intern();
    private static String PERMISSIONS = "exo:permissions".intern();
    private static String CACHED_RESULT = "exo:cachedResult".intern();

    public QueryPlugin(RepositoryService repositoryService, InitParams params, CmsConfigurationService cmsConfigService) throws Exception {
        Session session = repositoryService.getRepository().getSystemSession(cmsConfigService.getWorkspace());
        Iterator it = params.getObjectParamIterator();
        String queryPath = cmsConfigService.getJcrPath("queriesPath");
        Node queryHome = (Node)session.getItem(queryPath);
        ValueFactory vt = repositoryService.getRepository().getSystemSession(cmsConfigService.getWorkspace()).getValueFactory();
        while (it.hasNext()) {
            QueryData data = (QueryData)((ObjectParameter)it.next()).getObject();
            if (queryHome.hasNode(data.getName())) continue;
            Node queryNode = queryHome.addNode(data.getName(), "nt:query");
            queryNode.addMixin("mix:sharedQuery");
            queryNode.setProperty(STATEMENT, data.getStatement());
            queryNode.setProperty(LANGUAGE, data.getLanguage());
            Value vl = vt.createValue(data.getPermissions());
            Value[] vls = new Value[]{vl};
            queryNode.setProperty(PERMISSIONS, vls);
            queryNode.setProperty(CACHED_RESULT, data.getCacheResult());
            queryHome.save();
        }
        session.save();
    }
}

