/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.queries.QueryPlugin;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryServiceImpl
implements QueryService {
    private String relativePath_;
    private CmsConfigurationService cmsConfig_;
    private String workspace_;
    private QueryPlugin queryPlugin_;
    private RepositoryService repositoryService_;
    private CacheService cacheService_;
    private PortalContainerInfo containerInfo_;

    public QueryServiceImpl(RepositoryService repositoryService, CmsConfigurationService cmsConf, InitParams params, PortalContainerInfo containerInfo, CacheService cacheService) throws Exception {
        this.relativePath_ = params.getValueParam("relativePath").getValue();
        this.workspace_ = params.getValueParam("workspace").getValue();
        this.cmsConfig_ = cmsConf;
        this.repositoryService_ = repositoryService;
        this.containerInfo_ = containerInfo;
        this.cacheService_ = cacheService;
    }

    public void setQueryPlugin(QueryPlugin queryPlugin) {
        this.queryPlugin_ = queryPlugin;
    }

    public String getRelativePath() {
        return this.relativePath_;
    }

    public List<Query> getQueries() throws Exception {
        ArrayList<Query> queries = new ArrayList<Query>();
        String user = this.getRemoteUser();
        if (user == null) {
            return queries;
        }
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return queries;
        }
        QueryManager manager = session.getWorkspace().getQueryManager();
        Node usersHome = (Node)session.getItem(this.cmsConfig_.getJcrPath("usersPath"));
        Node userHome = usersHome.getNode(user);
        Node queriesHome = userHome.getNode(this.relativePath_);
        NodeIterator iter = queriesHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!"nt:query".equals(node.getPrimaryNodeType().getName())) continue;
            queries.add(manager.getQuery(node));
        }
        return queries;
    }

    public Query getQuery(String queryPath) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return null;
        }
        QueryManager manager = session.getWorkspace().getQueryManager();
        Node queryNode = (Node)session.getItem(queryPath);
        return manager.getQuery(queryNode);
    }

    public void addQuery(String queryName, String statement, String language) throws Exception {
        String user = this.getRemoteUser();
        if (user == null) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return;
        }
        QueryManager manager = session.getWorkspace().getQueryManager();
        Query query = manager.createQuery(statement, language);
        String usersHome = this.cmsConfig_.getJcrPath("usersPath");
        String absPath = usersHome + "/" + user + "/" + this.relativePath_ + "/" + queryName;
        query.storeAsNode(absPath);
        session.getItem(usersHome).save();
    }

    public void removeQuery(String queryPath) throws Exception {
        String user = this.getRemoteUser();
        if (user == null) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return;
        }
        Node queryNode = (Node)session.getItem(queryPath);
        Node queriesHome = queryNode.getParent();
        queryNode.remove();
        queriesHome.save();
        this.removeFromCache(queryPath);
    }

    private String getRemoteUser() {
        SessionContainer sessionContainer = SessionContainer.getInstance();
        if (sessionContainer != null) {
            return SessionContainer.getInstance().getRemoteUser();
        }
        return null;
    }

    public void addSharedQuery(String queryName, String statement, String language, String[] permissions, boolean cachedResult) throws Exception {
        String queryPath;
        ValueFactory vt;
        Session session = null;
        ArrayList<Value> perm = new ArrayList<Value>();
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
            vt = this.repositoryService_.getRepository().getSystemSession(this.workspace_).getValueFactory();
        }
        catch (RepositoryException re) {
            return;
        }
        for (String permission : permissions) {
            Value vl = vt.createValue(permission);
            perm.add(vl);
        }
        Value[] vls = perm.toArray(new Value[0]);
        String queriesPath = this.cmsConfig_.getJcrPath("queriesPath");
        Node queryHome = (Node)session.getItem(queriesPath);
        if (queryHome.hasNode(queryName)) {
            Node query = queryHome.getNode(queryName);
            query.setProperty("jcr:language", language);
            query.setProperty("jcr:statement", statement);
            query.setProperty("exo:permissions", vls);
            query.setProperty("exo:cachedResult", cachedResult);
            query.save();
            session.save();
            queryPath = query.getPath();
        } else {
            QueryManager manager = session.getWorkspace().getQueryManager();
            Query query = manager.createQuery(statement, language);
            Node newQuery = query.storeAsNode(queriesPath + "/" + queryName);
            newQuery.addMixin("mix:sharedQuery");
            newQuery.setProperty("exo:permissions", vls);
            newQuery.setProperty("exo:cachedResult", cachedResult);
            session.getItem(queriesPath).save();
            queryPath = queriesPath;
        }
        this.removeFromCache(queryPath);
    }

    public Node getSharedQuery(String queryName) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return null;
        }
        String queriesPath = this.cmsConfig_.getJcrPath("queriesPath");
        return (Node)session.getItem(queriesPath + "/" + queryName);
    }

    public List<Node> getSharedQueries(String queryType, List permissions) throws Exception {
        Session session = null;
        ArrayList<Node> queries = new ArrayList<Node>();
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return null;
        }
        String queriesPath = this.cmsConfig_.getJcrPath("queriesPath");
        Node queriesHome = (Node)session.getItem(queriesPath);
        NodeIterator iter = queriesHome.getNodes();
        block2: while (iter.hasNext()) {
            Node query = iter.nextNode();
            if (!query.getProperty("jcr:language").getString().equals(queryType)) continue;
            List applyPermissions = this.getPermissions(query);
            for (int i = 0; i < permissions.size(); ++i) {
                if (!this.hasPermission(permissions.get(i).toString(), applyPermissions)) continue;
                queries.add(query);
                continue block2;
            }
        }
        return queries;
    }

    public List<Node> getSharedQueries() throws Exception {
        Session session = null;
        ArrayList<Node> queries = new ArrayList<Node>();
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return queries;
        }
        Node sharedQueryHome = (Node)session.getItem(this.cmsConfig_.getJcrPath("queriesPath"));
        NodeIterator iter = sharedQueryHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!"nt:query".equals(node.getPrimaryNodeType().getName())) continue;
            queries.add(node);
        }
        return queries;
    }

    public void removeSharedQuery(String queryName) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return;
        }
        String queriesPath = this.cmsConfig_.getJcrPath("queriesPath");
        session.getItem(queriesPath + "/" + queryName).remove();
        session.save();
    }

    public List<Node> getSharedQueriesByPermissions(List permissions) throws Exception {
        List<Node> queries = this.getSharedQueries();
        ArrayList<Node> result = new ArrayList<Node>();
        block0: for (Node query : queries) {
            List applyPermissions = this.getPermissions(query);
            for (int i = 0; i < permissions.size(); ++i) {
                if (!this.hasPermission(permissions.get(i).toString(), applyPermissions)) continue;
                result.add(query);
                continue block0;
            }
        }
        return result;
    }

    private List getPermissions(Node query) throws Exception {
        Value[] values;
        ArrayList<String> permissions = new ArrayList<String>();
        for (Value value : values = query.getProperty("exo:permissions").getValues()) {
            permissions.add(value.getString());
        }
        return permissions;
    }

    private boolean hasPermission(String permission, List permissions) {
        if (permission == null) {
            return false;
        }
        if (permission.indexOf(":/") > -1) {
            String[] array = StringUtils.split((String)permission, (String)":/");
            if (array == null || array.length < 2) {
                return false;
            }
            if (permissions.indexOf("*:/" + array[1]) > -1) {
                return true;
            }
        }
        return permissions.contains(permission);
    }

    public QueryResult execute(String queryPath) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService_.getRepository().getSystemSession(this.workspace_);
        }
        catch (RepositoryException re) {
            return null;
        }
        Node queryNode = (Node)session.getItem(queryPath);
        if (queryNode.hasProperty("exo:cachedResult") && queryNode.getProperty("exo:cachedResult").getBoolean()) {
            String portalName;
            String key;
            ExoCache queryCache = this.cacheService_.getCacheInstance(QueryServiceImpl.class.getName());
            QueryResult result = (QueryResult)queryCache.get((Serializable)((Object)(key = (portalName = this.containerInfo_.getContainerName()) + queryPath)));
            if (result != null) {
                return result;
            }
            Query query = this.getQuery(queryPath);
            result = query.execute();
            queryCache.put((Serializable)((Object)key), (Object)result);
            return result;
        }
        Query query = this.getQuery(queryPath);
        return query.execute();
    }

    private void removeFromCache(String queryPath) throws Exception {
        String portalName;
        String key;
        ExoCache queryCache = this.cacheService_.getCacheInstance(QueryServiceImpl.class.getName());
        QueryResult result = (QueryResult)queryCache.get((Serializable)((Object)(key = (portalName = this.containerInfo_.getContainerName()) + queryPath)));
        if (result != null) {
            queryCache.remove((Serializable)((Object)key));
        }
    }
}

