/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.records;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.records.RecordsService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordsServiceImpl
implements RecordsService {
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DES";
    private ActionServiceContainer actionsService_;
    private AuditService auditService_;
    private static Log log_ = ExoLogger.getLogger((String)"services.records");

    public RecordsServiceImpl(ActionServiceContainer actionServiceContainer, AuditService auditService) {
        this.actionsService_ = actionServiceContainer;
        this.auditService_ = auditService;
    }

    public void bindFilePlanAction(Node filePlan) throws Exception {
        HashMap<String, JcrInputProperty> mappings = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeTypeInputProperty = new JcrInputProperty();
        nodeTypeInputProperty.setJcrPath("/node");
        nodeTypeInputProperty.setValue((Object)"processRecords");
        mappings.put("/node", nodeTypeInputProperty);
        JcrInputProperty nameInputProperty = new JcrInputProperty();
        nameInputProperty.setJcrPath("/node/exo:name");
        nameInputProperty.setValue((Object)"processRecords");
        mappings.put("/node/exo:name", nameInputProperty);
        JcrInputProperty lifeCycleInputProperty = new JcrInputProperty();
        lifeCycleInputProperty.setJcrPath("/node/exo:lifecyclePhase");
        lifeCycleInputProperty.setValue((Object)"add");
        mappings.put("/node/exo:lifecyclePhase", lifeCycleInputProperty);
        JcrInputProperty descriptionInputProperty = new JcrInputProperty();
        descriptionInputProperty.setJcrPath("/node/exo:description");
        descriptionInputProperty.setValue((Object)"compute info such as holding dates on a new record aded to that file plan");
        mappings.put("/node/exo:description", descriptionInputProperty);
        this.actionsService_.addAction(filePlan, "exo:processRecordAction", mappings);
    }

    public void addRecord(Node filePlan, Node record) throws RepositoryException {
        long counter = filePlan.getProperty("rma:recordCounter").getLong() + 1L;
        filePlan.setProperty("rma:recordCounter", counter);
        this.processDefaultRecordProperties(filePlan, record, counter);
        this.processVitalInformation(filePlan, record);
        this.processCutoffInformation(filePlan, record);
        record.addMixin("exo:auditable");
        record.save();
        filePlan.save();
        filePlan.getSession().save();
    }

    private void processDefaultRecordProperties(Node filePlan, Node record, long counter) throws RepositoryException {
        record.addMixin("rma:record");
        record.setProperty("rma:dateReceived", (Calendar)new GregorianCalendar());
        record.setProperty("rma:originator", ((ExtendedNode)record).getACL().getOwner());
        String recordCategoryIdentifier = filePlan.getProperty("rma:recordCategoryIdentifier").getString();
        String recordIdentifier = recordCategoryIdentifier + "-" + counter + " " + record.getName();
        record.setProperty("rma:recordIdentifier", recordIdentifier);
        String defaultOriginatingOrganization = filePlan.getProperty("rma:defaultOriginatingOrganization").getString();
        record.setProperty("rma:originatingOrganization", defaultOriginatingOrganization);
        Node dcNode = null;
        Item primaryItem = null;
        try {
            primaryItem = record.getPrimaryItem();
            if (primaryItem.isNode()) {
                dcNode = (Node)primaryItem;
            }
            dcNode = record;
        }
        catch (ItemNotFoundException e) {
            dcNode = record;
        }
        if (dcNode.isNodeType("dc:elementSet")) {
            Value[] formats;
            Value[] dates;
            Value[] subjects;
            if (dcNode.hasProperty("dc:subject") && (subjects = dcNode.getProperty("dc:subject").getValues()) != null && subjects.length > 0) {
                record.setProperty("rma:subject", subjects[0].getString());
            }
            if (dcNode.hasProperty("dc:date") && (dates = dcNode.getProperty("dc:date").getValues()) != null && dates.length > 0) {
                record.setProperty("rma:dateFiled", dates[0].getDate());
            }
            if (dcNode.hasProperty("dc:format") && (formats = dcNode.getProperty("dc:format").getValues()) != null && formats.length > 0) {
                record.setProperty("rma:format", formats[0].getString());
            }
        }
        record.save();
        filePlan.save();
    }

    private void processVitalInformation(Node filePlan, Node record) {
        try {
            boolean isVital = filePlan.getProperty("rma:vitalRecordIndicator").getBoolean();
            if (isVital) {
                record.addMixin("rma:vitalRecord");
                String vitalReviewPeriod = filePlan.getProperty("rma:vitalRecordReviewPeriod").getString();
                Calendar previousReviewDate = null;
                GregorianCalendar currentDate = new GregorianCalendar();
                previousReviewDate = record.hasProperty("rma:nextReviewDate") ? record.getProperty("rma:nextReviewDate").getDate() : currentDate;
                record.setProperty("rma:prevReviewDate", previousReviewDate);
                this.calculateNextRevDate(currentDate, vitalReviewPeriod);
                record.setProperty("rma:nextReviewDate", (Calendar)currentDate);
                record.save();
                filePlan.save();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private void processCutoffInformation(Node filePlan, Node record) {
        try {
            boolean isCutoffable = filePlan.getProperty("rma:processCutoff").getBoolean();
            if (isCutoffable) {
                boolean cutoffSuperseded;
                boolean cutoffObsolete;
                record.addMixin("rma:cutoffable");
                String cutoffPeriod = filePlan.getProperty("rma:cutoffPeriod").getString();
                if (cutoffPeriod != null) {
                    GregorianCalendar currentDate = new GregorianCalendar();
                    this.calculateNextRevDate(currentDate, cutoffPeriod);
                    record.setProperty("rma:cutoffDateTime", (Calendar)currentDate);
                }
                if (cutoffObsolete = filePlan.getProperty("rma:cutoffOnObsolete").getBoolean()) {
                    record.setProperty("rma:cutoffObsolete", true);
                }
                if (cutoffSuperseded = filePlan.getProperty("rma:cutoffOnSuperseded").getBoolean()) {
                    record.setProperty("rma:cutoffSuperseded", true);
                }
                try {
                    String eventTrigger = filePlan.getProperty("rma:eventTrigger").getString();
                    if (eventTrigger != null) {
                        record.setProperty("rma:cutoffEvent", eventTrigger);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            record.save();
            filePlan.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void computeCutoffs(Node filePlan) throws RepositoryException {
        List<Node> toCutoffList = this.getCutoffRecords(filePlan);
        for (Node record : toCutoffList) {
            if (this.cutoffObsolete(filePlan, record)) {
                return;
            }
            if (this.cutoffSuperseded(filePlan, record)) {
                return;
            }
            if (this.cutoffHasExpired(filePlan, record)) {
                return;
            }
            if (this.cutoffNow(filePlan, record)) {
                return;
            }
            if (!this.cutoffEvent(filePlan, record)) continue;
            return;
        }
    }

    private boolean cutoffObsolete(Node filePlan, Node record) throws RepositoryException {
        boolean cutoffIsObsolete = record.getProperty("rma:isObsolete").getBoolean();
        if (cutoffIsObsolete) {
            log_.info((Object)"Cutoff is obsolete");
            this.computeNextRecordPhaseAfterCutoff(filePlan, record);
            return true;
        }
        return false;
    }

    private boolean cutoffSuperseded(Node filePlan, Node record) throws RepositoryException {
        try {
            record.getProperty("rma:superseded").getNode();
            log_.info((Object)"Cutoff is superseded");
            this.computeNextRecordPhaseAfterCutoff(filePlan, record);
            return true;
        }
        catch (ItemNotFoundException ex) {
            log_.error((Object)ex.getMessage());
            return false;
        }
    }

    private boolean cutoffHasExpired(Node filePlan, Node record) throws RepositoryException {
        GregorianCalendar currentDate = new GregorianCalendar();
        Calendar cutoffDateTime = record.getProperty("rma:cutoffDateTime").getDate();
        if (currentDate.after(cutoffDateTime)) {
            log_.info((Object)"Cutoff has expired");
            this.computeNextRecordPhaseAfterCutoff(filePlan, record);
            return true;
        }
        return false;
    }

    private boolean cutoffNow(Node filePlan, Node record) throws RepositoryException {
        boolean cutoffNow = record.getProperty("rma:cutoffNow").getBoolean();
        if (cutoffNow) {
            log_.info((Object)"Cutoff record now");
            this.computeNextRecordPhaseAfterCutoff(filePlan, record);
            return true;
        }
        return false;
    }

    private boolean cutoffEvent(Node filePlan, Node record) throws RepositoryException {
        return false;
    }

    private void computeNextRecordPhaseAfterCutoff(Node filePlan, Node record) throws RepositoryException {
        boolean processHold = filePlan.getProperty("rma:processHold").getBoolean();
        boolean processTransfer = filePlan.getProperty("rma:processTransfer").getBoolean();
        boolean processDestruction = filePlan.getProperty("rma:processDestruction").getBoolean();
        if (processHold) {
            record.addMixin("rma:holdable");
            boolean discretionaryHold = filePlan.getProperty("rma:discretionaryHold").getBoolean();
            if (discretionaryHold) {
                record.setProperty("rma:holdsDiscretionary", true);
                record.setProperty("rma:holdUntilEvent", "EventToWaitFor");
            } else {
                String holdPeriod = filePlan.getProperty("rma:holdPeriod").getString();
                if (holdPeriod != null) {
                    GregorianCalendar currentDate = new GregorianCalendar();
                    this.calculateNextRevDate(currentDate, holdPeriod);
                    record.setProperty("rma:holdUntil", (Calendar)currentDate);
                }
            }
        } else if (processTransfer) {
            this.setupTransfer(filePlan, record);
        } else if (processDestruction) {
            this.setupDestruction(filePlan, record);
        }
        record.setProperty("rma:cutoffExecuted", true);
        record.save();
        filePlan.save();
    }

    public void computeHolds(Node filePlan) throws RepositoryException {
        List<Node> toHoldList = this.getHolableRecords(filePlan);
        for (Node record : toHoldList) {
            GregorianCalendar currentDate;
            boolean isFrozenRecord = record.getProperty("rma:freeze").getBoolean();
            if (isFrozenRecord) continue;
            if (record.hasProperty("rma:holdsDiscretionary") && record.getProperty("rma:holdsDiscretionary").getBoolean()) {
                String eventToWaitFor = record.getProperty("rma:holdUntilEvent").getString();
                record.setProperty("rma:holdExecuted", true);
                record.save();
                continue;
            }
            Calendar holdUntil = record.getProperty("rma:holdUntil").getDate();
            if (holdUntil.before(currentDate = new GregorianCalendar())) {
                boolean processTransfer = filePlan.getProperty("rma:processTransfer").getBoolean();
                boolean processDestruction = filePlan.getProperty("rma:processDestruction").getBoolean();
                if (processTransfer) {
                    this.setupTransfer(filePlan, record);
                } else if (processDestruction) {
                    this.setupDestruction(filePlan, record);
                }
                record.setProperty("rma:holdExecuted", true);
                record.save();
                filePlan.save();
                continue;
            }
            log_.info((Object)"Record still in holding");
        }
        filePlan.save();
    }

    public void setupTransfer(Node filePlan, Node record) {
        try {
            record.addMixin("rma:transferable");
            String location = filePlan.getProperty("rma:defaultTransferLocation").getString();
            record.setProperty("rma:transferLocation", location);
            GregorianCalendar currentDate = new GregorianCalendar();
            ((Calendar)currentDate).add(12, 5);
            record.setProperty("rma:transferDate", (Calendar)currentDate);
            record.save();
            filePlan.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void computeTransfers(Node filePlan) throws RepositoryException {
        log_.info((Object)"Compute records transfer");
        List<Node> toTransfer = this.getTransferableRecords(filePlan);
        for (Node record : toTransfer) {
            GregorianCalendar currentDate;
            Calendar transferDate = record.getProperty("rma:transferDate").getDate();
            if (!transferDate.before(currentDate = new GregorianCalendar())) continue;
            Session session = record.getSession();
            String transferLocation = record.getProperty("rma:transferLocation").getString();
            log_.info((Object)("Transfer record to: " + transferLocation));
            if (transferLocation != null && !"".equals(transferLocation)) {
                try {
                    session.getWorkspace().copy(record.getPath(), transferLocation + "/" + record.getName());
                }
                catch (ItemNotFoundException ex) {
                    log_.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            record.setProperty("rma:transferExecuted", true);
            record.save();
            filePlan.save();
        }
        log_.info((Object)"Transfer records over");
    }

    public void computeAccessions(Node filePlan) throws RepositoryException {
        log_.info((Object)"Compute records accession");
        List<Node> toAccessionList = this.getAccessionableRecords(filePlan);
        for (Node record : toAccessionList) {
            GregorianCalendar currentDate;
            Calendar accessionDate = record.getProperty("rma:accessionableDate").getDate();
            if (!accessionDate.before(currentDate = new GregorianCalendar())) continue;
            Session session = record.getSession();
            String accessionLocation = filePlan.getProperty("rma:accessionLocation").getString();
            if (accessionLocation != null && !"".equals(accessionLocation)) {
                try {
                    session.getWorkspace().copy(record.getPath(), accessionLocation + "/" + record.getName());
                }
                catch (ItemNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            record.setProperty("rma:accessionExecuted", true);
            record.save();
            filePlan.save();
        }
        log_.info((Object)"Compute records accession over");
    }

    public void computeDestructions(Node filePlan) throws RepositoryException {
        List<Node> toDestroyList = this.getDestroyableRecords(filePlan);
        for (Node record : toDestroyList) {
            GregorianCalendar currentDate;
            Calendar destructionDate = record.getProperty("rma:destructionDate").getDate();
            if (!destructionDate.after(currentDate = new GregorianCalendar())) continue;
            record.remove();
            filePlan.save();
        }
    }

    public void setupDestruction(Node filePlan, Node record) {
        try {
            record.addMixin("rma:destroyable");
            GregorianCalendar currentDate = new GregorianCalendar();
            ((Calendar)currentDate).add(12, 5);
            record.setProperty("rma:destructionDate", (Calendar)currentDate);
            record.save();
            filePlan.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void setupAccession(Node filePlan, Node record) {
        try {
            boolean processAccession = filePlan.getProperty("rma:processAccession").getBoolean();
            if (processAccession) {
                record.addMixin("rma:accessionable");
                GregorianCalendar currentDate = new GregorianCalendar();
                ((Calendar)currentDate).add(12, 5);
                record.setProperty("rma:accessionDate", (Calendar)currentDate);
                record.save();
                filePlan.save();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public List<Node> getAccessionableRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:accessionable") || child.getProperty("rma:accessionExecuted").getBoolean()) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getCutoffRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:cutoffable") || child.getProperty("rma:cutoffExecuted").getBoolean()) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getDestroyableRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:destroyable")) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getHolableRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:holdable") || child.getProperty("rma:holdExecuted").getBoolean()) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getObsoleteRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:record") || !child.getProperty("rma:isObsolete").getBoolean()) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getSupersededRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:record") || !child.getProperty("rma:superseded").getValue().getString().equals("true")) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getTransferableRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:transferable") || child.getProperty("rma:transferExecuted").getBoolean()) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    public List<Node> getVitalRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:vitalRecord")) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(DESCENDING, "rma:nextReviewDate"));
        return list;
    }

    public List<Node> getRecords(Node filePlan) throws RepositoryException {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = filePlan.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType("rma:record")) continue;
            list.add(child);
        }
        Collections.sort(list, new DateComparator(ASCENDING, "rma:dateReceived"));
        return list;
    }

    private void calculateNextRevDate(Calendar currentDate, String period) {
        if ("one minute".equals(period)) {
            currentDate.add(12, 1);
        } else if ("hourly".equals(period)) {
            currentDate.add(10, 1);
        } else if ("daily".equals(period)) {
            currentDate.add(10, 24);
        } else if ("monthly".equals(period)) {
            currentDate.add(2, 1);
        } else if ("quarterly".equals(period)) {
            currentDate.add(2, 4);
        } else if ("yearly".equals(period)) {
            currentDate.add(1, 1);
        } else if ("ten years".equals(period)) {
            currentDate.add(1, 10);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateComparator
    implements Comparator<Node> {
        private String oder_;
        private String dateProperty_;

        public DateComparator(String oder, String propertyName) {
            this.oder_ = oder;
            this.dateProperty_ = propertyName;
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                Calendar calendar1 = o1.getProperty(this.dateProperty_).getDate();
                Calendar calendar2 = o2.getProperty(this.dateProperty_).getDate();
                if (RecordsServiceImpl.ASCENDING.equals(this.oder_)) {
                    return calendar1.compareTo(calendar2);
                }
                return calendar2.compareTo(calendar1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

