/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.rules;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseLoader;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.BaseResourceLoaderService;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.cms.rules.RuleService;
import org.exoplatform.services.jcr.RepositoryService;

public class RuleServiceImpl
extends BaseResourceLoaderService
implements RuleService {
    public RuleServiceImpl(RepositoryService repositoryService, CmsConfigurationService cmsConfigService, ConfigurationManager cservice, CacheService cacheService, InitParams params) throws Exception {
        super((ResourceConfig)params.getObjectParamValues(ResourceConfig.class).get(0), cservice, cmsConfigService, repositoryService, cacheService);
    }

    public WorkingMemory getRule(String ruleName) throws Exception {
        Object obj = this.resourceCache_.get((Serializable)((Object)ruleName));
        if (obj != null) {
            return (WorkingMemory)obj;
        }
        ByteArrayInputStream iS = new ByteArrayInputStream(this.getRuleAsText(ruleName).getBytes());
        RuleBase ruleBase = RuleBaseLoader.loadFromInputStream((InputStream)iS);
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        this.resourceCache_.put((Serializable)((Object)ruleName), (Object)workingMemory);
        return workingMemory;
    }

    public String getRuleAsText(String ruleName) throws Exception {
        return this.getResourceAsText(ruleName);
    }

    public NodeIterator getRules() throws Exception {
        return this.getResources();
    }

    public boolean hasRules() throws Exception {
        return this.hasResources();
    }

    public void addRule(String name, String text) throws Exception {
        this.addResource(name, text);
    }

    public void removeRule(String ruleName) throws Exception {
        this.removeResource(ruleName);
        this.removeFromCache(ruleName);
    }

    protected String getBasePath() {
        return this.cmsConfigService_.getJcrPath("cmsRulesPath");
    }

    protected void removeFromCache(String resourceName) {
        try {
            this.resourceCache_.remove((Serializable)((Object)resourceName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Node getRuleNode(String ruleName) throws Exception {
        try {
            Node ruleHome = this.getResourcesHome();
            return ruleHome.getNode(ruleName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

